/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy.behaviors;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class ItemDropBehavior
extends CustomBehavior {
    private Item itemToDrop;
    private int cooldown;
    private SoundEvent sound;

    public ItemDropBehavior() {
    }

    public ItemDropBehavior(Item drop, int cooldown) {
        this(drop, cooldown, null);
    }

    public ItemDropBehavior(Item drop, int cooldown, @Nullable SoundEvent sound) {
        this.itemToDrop = drop;
        this.cooldown = cooldown;
        this.sound = sound;
    }

    @Override
    public ResourceLocation getType() {
        return OpenBlocksTrophies.location("item");
    }

    @Override
    public void serializeToJson(JsonObject object, JsonSerializationContext context) {
        object.add("item", context.serialize((Object)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.itemToDrop).toString()));
        object.add("cooldown", context.serialize((Object)this.cooldown));
        if (this.sound != null) {
            object.add("sound", context.serialize((Object)ForgeRegistries.SOUND_EVENTS.getKey((IForgeRegistryEntry)this.sound).toString()));
        }
    }

    @Override
    public CustomBehavior fromJson(JsonObject object) {
        Item item = GsonHelper.m_13909_((JsonObject)object, (String)"item");
        int cooldown = GsonHelper.m_13824_((JsonObject)object, (String)"cooldown", (int)1000);
        SoundEvent sound = null;
        if (object.has("sound")) {
            sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"sound")));
        }
        return new ItemDropBehavior(item, cooldown, sound);
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player) {
        if (this.sound != null) {
            player.m_183503_().m_5594_(null, player.m_142538_(), this.sound, SoundSource.BLOCKS, 1.0f, (block.m_58904_().m_5822_().nextFloat() - block.m_58904_().m_5822_().nextFloat()) * 0.2f + 1.0f);
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)this.itemToDrop).m_41777_());
        return this.cooldown;
    }
}

