/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy.behaviors;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class ShootArrowBehavior
extends CustomBehavior {
    private final int amount;
    private final MobEffect arrowEffect;

    public ShootArrowBehavior() {
        this(1, null);
    }

    public ShootArrowBehavior(int amount, @Nullable MobEffect arrowEffect) {
        this.amount = amount;
        this.arrowEffect = arrowEffect;
    }

    @Override
    public ResourceLocation getType() {
        return OpenBlocksTrophies.location("arrow");
    }

    @Override
    public void serializeToJson(JsonObject object, JsonSerializationContext context) {
        object.add("amount", context.serialize((Object)this.amount));
        if (this.arrowEffect != null) {
            object.add("effect", context.serialize((Object)ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)this.arrowEffect).toString()));
        }
    }

    @Override
    public CustomBehavior fromJson(JsonObject object) {
        int amount = GsonHelper.m_13824_((JsonObject)object, (String)"amount", (int)1);
        MobEffect effect = null;
        if (object.has("effect")) {
            effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"effect")));
        }
        return new ShootArrowBehavior(amount, effect);
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player) {
        BlockPos pos = block.m_58899_();
        Level level = block.m_58904_();
        for (int i = 0; i < this.amount; ++i) {
            Arrow arrow = new Arrow(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)pos.m_123343_() + 0.5);
            arrow.m_36781_(0.1);
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            if (this.arrowEffect != null) {
                arrow.m_36870_(new MobEffectInstance(this.arrowEffect));
            }
            arrow.m_6686_((double)(level.m_5822_().nextInt(10) - 5), 40.0, (double)(level.m_5822_().nextInt(10) - 5), 1.0f, 6.0f);
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (level.m_5822_().nextFloat() * 0.4f + 1.2f) + 0.5f);
            level.m_7967_((Entity)arrow);
        }
        return 0;
    }
}

