/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.TrophiesCommands;
import com.gizmo.trophies.TrophyConfig;
import com.gizmo.trophies.TrophyNetworkHandler;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.Trophy;
import com.gizmo.trophies.trophy.behaviors.CustomBehaviorRegistry;
import com.gizmo.trophies.trophy.behaviors.ElderGuardianCurseBehavior;
import com.gizmo.trophies.trophy.behaviors.ExplosionBehavior;
import com.gizmo.trophies.trophy.behaviors.ItemDropBehavior;
import com.gizmo.trophies.trophy.behaviors.MobEffectBehavior;
import com.gizmo.trophies.trophy.behaviors.PlaceBlockBehavior;
import com.gizmo.trophies.trophy.behaviors.PlayerSetFireBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootArrowBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootEnderPearlBehavior;
import com.gizmo.trophies.trophy.behaviors.ShootLlamaSpitBehavior;
import com.gizmo.trophies.trophy.behaviors.TotemOfUndyingEffectBehavior;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="obtrophies")
public class OpenBlocksTrophies {
    public static final String MODID = "obtrophies";
    public static final Logger LOGGER = LogManager.getLogger((String)"obtrophies");
    public static final RandomSource TROPHY_RANDOM = RandomSource.m_216327_();

    public OpenBlocksTrophies() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TrophyConfig.CommonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TrophyConfig.COMMON_CONFIG = (TrophyConfig.CommonConfig)specPair.getLeft();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::createTab);
        MinecraftForge.EVENT_BUS.addListener(this::maybeDropTrophy);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(Trophy::reloadTrophies);
        MinecraftForge.EVENT_BUS.addListener(Trophy::syncTrophiesToClient);
        Registries.BLOCKS.register(bus);
        Registries.BLOCK_ENTITIES.register(bus);
        Registries.ITEMS.register(bus);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CustomBehaviorRegistry.registerBehavior(new MobEffectBehavior());
            CustomBehaviorRegistry.registerBehavior(new ItemDropBehavior());
            CustomBehaviorRegistry.registerBehavior(new ElderGuardianCurseBehavior());
            CustomBehaviorRegistry.registerBehavior(new ExplosionBehavior());
            CustomBehaviorRegistry.registerBehavior(new PlaceBlockBehavior());
            CustomBehaviorRegistry.registerBehavior(new PlayerSetFireBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootArrowBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootEnderPearlBehavior());
            CustomBehaviorRegistry.registerBehavior(new ShootLlamaSpitBehavior());
            CustomBehaviorRegistry.registerBehavior(new TotemOfUndyingEffectBehavior());
        });
        TrophyNetworkHandler.init();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TrophiesCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void createTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(OpenBlocksTrophies.location("trophies"), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.obtrophies")).m_257737_(TrophyTabHelper::makeIcon).m_257501_((flag, output, operator) -> TrophyTabHelper.getAllTrophies(output, flag)));
    }

    public void maybeDropTrophy(LivingDropsEvent event) {
        Trophy trophy;
        if (!(event.getSource().m_7639_() instanceof Player) && !((Boolean)TrophyConfig.COMMON_CONFIG.anySourceDropsTrophies.get()).booleanValue()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof FakePlayer && !((Boolean)TrophyConfig.COMMON_CONFIG.fakePlayersDropTrophies.get()).booleanValue()) {
            return;
        }
        if (Trophy.getTrophies().containsKey(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_())) && (trophy = Trophy.getTrophies().get(ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()))) != null) {
            double trophyDropChance = (Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get() >= 0.0 ? ((Double)TrophyConfig.COMMON_CONFIG.dropChanceOverride.get()).doubleValue() : trophy.dropChance();
            double chance = ((double)event.getLootingLevel() + TROPHY_RANDOM.m_188500_() / 4.0) * trophyDropChance - TROPHY_RANDOM.m_188500_();
            if (chance > 0.0) {
                event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), TrophyItem.loadEntityToTrophy(trophy.type(), false)));
            }
        }
    }

    public static class TrophyTabHelper {
        public static ItemStack makeIcon() {
            return TrophyItem.loadEntityToTrophy(EntityType.f_20555_, !Trophy.getTrophies().isEmpty());
        }

        public static void getAllTrophies(CreativeModeTab.Output output, FeatureFlagSet flag) {
            if (!Trophy.getTrophies().isEmpty()) {
                TreeMap sortedTrophies = new TreeMap(Comparator.naturalOrder());
                sortedTrophies.putAll(Trophy.getTrophies());
                for (Map.Entry trophyEntry : sortedTrophies.entrySet()) {
                    if (((Trophy)trophyEntry.getValue()).type() == EntityType.f_243976_ && !flag.m_245372_(FeatureFlags.f_244168_)) continue;
                    output.m_246342_(TrophyItem.loadEntityToTrophy(((Trophy)trophyEntry.getValue()).type(), false));
                }
            }
        }
    }
}

