/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.item.TrophyItem;
import com.gizmo.trophies.trophy.AmbientSoundFetcher;
import com.gizmo.trophies.trophy.Trophy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TrophyBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty PEDESTAL = BooleanProperty.m_61465_((String)"pedestal");
    private static final VoxelShape PEDESTAL_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape NO_PEDESTAL_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PEDESTAL, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockAtPos, BlockEntityType<E> fedBlock, BlockEntityTicker<? super E> ticker) {
        return fedBlock == blockAtPos ? ticker : null;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)PEDESTAL) != false ? PEDESTAL_SHAPE : Shapes.m_83040_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)PEDESTAL) != false ? PEDESTAL_SHAPE : NO_PEDESTAL_SHAPE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyBE = (TrophyBlockEntity)be;
            Trophy trophy = TrophyItem.getTrophy(stack);
            if (trophy != null) {
                trophyBE.setTrophy(trophy);
                CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
                if (tag != null && tag.m_128441_("cooldown")) {
                    trophyBE.setCooldown(tag.m_128451_("cooldown"));
                }
                if (tag != null && tag.m_128441_("SpecialCycleVariant")) {
                    trophyBE.setCycling(tag.m_128471_("SpecialCycleVariant"));
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        TrophyBlockEntity trophyBE;
        Trophy trophy;
        BlockEntity blockEntity;
        if (player.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)PEDESTAL));
            level.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof TrophyBlockEntity && (trophy = (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy()) != null) {
            SoundEvent ambientSound = AmbientSoundFetcher.getAmbientSound(trophy.type(), level);
            if (ambientSound != null) {
                level.m_5594_(null, pos, ambientSound, SoundSource.BLOCKS, 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
            }
            if (trophyBE.getCooldown() <= 0 && trophy.behavior() != null) {
                trophyBE.setCooldown(trophy.behavior().execute(trophyBE, (ServerPlayer)player));
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        TrophyBlockEntity trophyBE;
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof TrophyBlockEntity && (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy() != null) {
            ItemStack newStack = new ItemStack((ItemLike)this);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entity", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophyBE.getTrophy().type())).toString());
            if (trophyBE.getCooldown() > 0) {
                tag.m_128405_("cooldown", trophyBE.getCooldown());
            }
            if (trophyBE.isCycling()) {
                tag.m_128379_("SpecialCycleVariant", true);
            }
            newStack.m_41700_("BlockEntityTag", (Tag)tag);
            drop.add(newStack);
        }
        return drop;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter getter, BlockPos pos, Player player) {
        TrophyBlockEntity trophyBE;
        ItemStack newStack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof TrophyBlockEntity && (trophyBE = (TrophyBlockEntity)blockEntity).getTrophy() != null) {
            tag.m_128359_("entity", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(trophyBE.getTrophy().type())).toString());
            if (trophyBE.isCycling()) {
                tag.m_128379_("SpecialCycleVariant", true);
            }
            newStack.m_41700_("BlockEntityTag", (Tag)tag);
        }
        return newStack;
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, PEDESTAL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : TrophyBlock.createTickerHelper(type, (BlockEntityType)Registries.TROPHY_BE.get(), (level1, pos, state1, blockEntity) -> TrophyBlockEntity.tick(blockEntity));
    }
}

