/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.block;

import com.gizmo.trophies.Registries;
import com.gizmo.trophies.trophy.Trophy;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TrophyBlockEntity
extends BlockEntity {
    private int cooldown = 0;
    private Trophy trophy;
    private boolean specialCycleVariant = false;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registries.TROPHY_BE.get(), pos, state);
    }

    public static void tick(TrophyBlockEntity be) {
        if (be.cooldown > 0) {
            --be.cooldown;
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Nullable
    public Trophy getTrophy() {
        return this.trophy;
    }

    public void setTrophy(Trophy trophy) {
        this.trophy = trophy;
        this.markUpdated();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.getTrophy() != null) {
            tag.m_128359_("entity", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(this.getTrophy().type())).toString());
        }
        tag.m_128405_("cooldown", this.getCooldown());
        if (this.specialCycleVariant) {
            tag.m_128379_("SpecialCycleVariant", true);
        }
    }

    public boolean isCycling() {
        return this.specialCycleVariant;
    }

    public void setCycling(boolean cycling) {
        this.specialCycleVariant = cycling;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (Trophy.getTrophies().containsKey(ResourceLocation.m_135820_((String)tag.m_128461_("entity")))) {
            this.setTrophy(Trophy.getTrophies().get(ResourceLocation.m_135820_((String)tag.m_128461_("entity"))));
        }
        this.setCooldown(tag.m_128451_("cooldown"));
        if (tag.m_128441_("SpecialCycleVariant")) {
            this.specialCycleVariant = tag.m_128471_("SpecialCycleVariant");
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(Objects.requireNonNull(pkt.m_131708_()));
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.updateClient();
    }

    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tile -> this.m_5995_());
    }

    private void markUpdated() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            this.m_58900_().m_60701_((LevelAccessor)this.m_58904_(), this.m_58899_(), 2);
        }
    }

    private void updateClient() {
        if (this.m_58904_() != null && this.m_58904_().m_5776_()) {
            this.requestModelDataUpdate();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

