/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.client;

import com.github.alexthe666.alexsmobs.client.render.RenderLaviathan;
import com.github.alexthe666.alexsmobs.client.render.RenderMurmurBody;
import com.github.alexthe666.alexsmobs.entity.EntityLaviathan;
import com.gizmo.trophies.block.TrophyBlock;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.client.TrophyExtraRendering;
import com.gizmo.trophies.trophy.Trophy;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class TrophyRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private static List<ResourceLocation> keys = new ArrayList<ResourceLocation>();
    private static final LoadingCache<EntityContext<?>, Entity> ENTITY_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<EntityContext<?>, Entity>(){

        public Entity load(EntityContext<?> context) {
            return context.createEntity();
        }
    });

    public TrophyRenderer(BlockEntityRendererProvider.Context unused) {
    }

    public static void renderEntity(@Nullable TrophyBlockEntity be, Level level, BlockPos pos, Trophy trophy, PoseStack stack, MultiBufferSource source, int light, boolean cycling) {
        stack.m_85836_();
        if (keys.isEmpty() && !Trophy.getTrophies().isEmpty()) {
            keys = Trophy.getTrophies().keySet().stream().toList();
        }
        if (cycling && !keys.isEmpty()) {
            trophy = Trophy.getTrophies().get(keys.get((int)(level.m_46467_() / 20L % (long)keys.size())));
        }
        Entity entity = TrophyRenderer.fetchEntity(trophy.type(), level);
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        boolean hitboxes = dispatcher.m_114377_();
        dispatcher.m_114468_(false);
        dispatcher.m_114473_(false);
        entity.m_146922_(0.0f);
        entity.m_5616_(0.0f);
        entity.m_5618_(0.0f);
        entity.m_6853_(true);
        entity.f_19812_ = false;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(true);
        }
        entity.m_20340_(false);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25 + trophy.verticalOffset(), (double)pos.m_123343_() + 0.5);
        stack.m_85837_(0.5, 0.25 + trophy.verticalOffset(), 0.5);
        if (be != null) {
            if (LocalDate.of(LocalDate.now().getYear(), 4, 1).equals(LocalDate.now())) {
                Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, false);
                if (player != null) {
                    Vec3 vec3 = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
                    Vec3 vec31 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_() + (double)entity.m_20192_() / 1.5, (double)pos.m_123343_());
                    Vec3 vec32 = vec3.m_82546_(vec31);
                    vec32 = vec32.m_82541_();
                    float f5 = (float)Math.acos(vec32.m_7098_());
                    float f6 = (float)Math.atan2(vec32.m_7094_(), vec32.m_7096_());
                    stack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
                    stack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f - 90.0f));
                }
            } else {
                stack.m_252781_(Axis.f_252436_.m_252977_(TrophyRenderer.getCorrectRotation(((Direction)be.m_58900_().m_61143_((Property)TrophyBlock.f_54117_)).m_122424_())));
            }
        }
        if (entity instanceof EnderDragon) {
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        stack.m_85841_(0.4f, 0.4f, 0.4f);
        stack.m_85841_(trophy.scale(), trophy.scale(), trophy.scale());
        if (TrophyExtraRendering.getRenderMap().containsKey(trophy.type())) {
            TrophyExtraRendering.getRenderForEntity(trophy.type()).createExtraRender(entity);
        }
        if (ModList.get().isLoaded("alexsmobs")) {
            RenderLaviathan.renderWithoutShaking = true;
            RenderMurmurBody.renderWithHead = true;
            if (entity instanceof EntityLaviathan) {
                EntityLaviathan leviathan = (EntityLaviathan)entity;
                leviathan.prevHeadHeight = 0.0f;
                leviathan.setChillTime(0);
            }
        }
        RenderSystem.m_69890_(() -> dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, source, light));
        dispatcher.m_114468_(true);
        dispatcher.m_114473_(hitboxes);
        if (ModList.get().isLoaded("alexsmobs")) {
            RenderLaviathan.renderWithoutShaking = false;
            RenderMurmurBody.renderWithHead = false;
        }
        stack.m_85849_();
    }

    private static float getCorrectRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP, Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            case Direction.WEST -> 90.0f;
        };
    }

    @Nullable
    public static <T extends Entity> Entity fetchEntity(@Nullable EntityType<T> type, Level level) {
        if (type == null) {
            return null;
        }
        return (Entity)ENTITY_CACHE.getUnchecked(EntityContext.of(type, level));
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        if (blockEntity.getTrophy() != null) {
            stack.m_85836_();
            if (!((Boolean)blockEntity.m_58900_().m_61143_((Property)TrophyBlock.PEDESTAL)).booleanValue()) {
                stack.m_85837_(0.0, -0.25, 0.0);
            }
            TrophyRenderer.renderEntity(blockEntity, blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.getTrophy(), stack, source, light, blockEntity.isCycling());
            stack.m_85849_();
        }
    }

    public record EntityContext<T extends Entity>(EntityType<T> type, Level level) {
        public static <T extends Entity> EntityContext<T> of(EntityType<T> type, Level level) {
            return new EntityContext<T>(type, level);
        }

        public T createEntity() {
            return (T)Objects.requireNonNull(this.type.m_20615_(this.level));
        }
    }
}

