/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.trophies.trophy.behaviors;

import com.gizmo.trophies.OpenBlocksTrophies;
import com.gizmo.trophies.block.TrophyBlockEntity;
import com.gizmo.trophies.trophy.behaviors.CustomBehavior;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class PlaceBlockBehavior
extends CustomBehavior {
    private Block blockToPlace;
    private boolean aroundTrophy;

    public PlaceBlockBehavior() {
    }

    public PlaceBlockBehavior(Block block, boolean placeAroundTrophy) {
        this.blockToPlace = block;
        this.aroundTrophy = placeAroundTrophy;
    }

    @Override
    public ResourceLocation getType() {
        return OpenBlocksTrophies.location("place_block");
    }

    @Override
    public void serializeToJson(JsonObject object, JsonSerializationContext context) {
        object.add("block", context.serialize((Object)ForgeRegistries.BLOCKS.getKey((Object)this.blockToPlace).toString()));
        object.add("place_around_trophy", context.serialize((Object)this.aroundTrophy));
    }

    @Override
    public CustomBehavior fromJson(JsonObject object) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"block")));
        boolean placeAround = GsonHelper.m_13912_((JsonObject)object, (String)"place_around_trophy");
        return new PlaceBlockBehavior(block, placeAround);
    }

    @Override
    public int execute(TrophyBlockEntity block, ServerPlayer player) {
        BlockPos base = block.m_58899_();
        Level level = block.m_58904_();
        assert (level != null);
        if (this.aroundTrophy) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    LiquidBlock liquid;
                    BlockPos pos = base.m_7918_(x, 0, z);
                    if (!level.m_8055_(pos).m_60795_() || !this.blockToPlace.m_7898_(this.blockToPlace.m_49966_(), (LevelReader)level, pos)) continue;
                    Block block2 = this.blockToPlace;
                    if (block2 instanceof SnowLayerBlock) {
                        SnowLayerBlock layer = (SnowLayerBlock)block2;
                        int layers = level.m_213780_().m_188503_(8) + 1;
                        level.m_46597_(pos, (BlockState)layer.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers)));
                        continue;
                    }
                    Block block3 = this.blockToPlace;
                    if (block3 instanceof LiquidBlock && (liquid = (LiquidBlock)block3).getFluid().getFluidType().isVaporizedOnPlacement(level, pos, null)) {
                        level.m_5594_(null, base, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f);
                        return 100;
                    }
                    level.m_46597_(pos, this.blockToPlace.m_49966_());
                }
            }
        } else {
            LiquidBlock liquid;
            BlockPos pos = base.m_7494_();
            Block block4 = this.blockToPlace;
            if (block4 instanceof LiquidBlock && (liquid = (LiquidBlock)block4).getFluid().getFluidType().isVaporizedOnPlacement(level, pos, null)) {
                level.m_5594_(null, base, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f);
                return 100;
            }
            if (level.m_8055_(pos).m_60795_() && this.blockToPlace.m_7898_(this.blockToPlace.m_49966_(), (LevelReader)level, pos)) {
                level.m_46597_(pos, this.blockToPlace.m_49966_());
            }
        }
        return 100;
    }
}

