/*
 * Decompiled with CFR 0.152.
 */
package com.nanokulon.primalstage.blocks.entity;

import com.nanokulon.primalstage.init.ModBlockEntities;
import com.nanokulon.primalstage.init.ModRecipes;
import com.nanokulon.primalstage.recipes.DryingRecipe;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlockEntity
extends class_2586 {
    private final class_2371<class_1799> itemsBeingDrying = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final class_1863.class_7266<class_1263, DryingRecipe> matchGetter = class_1863.method_42302(ModRecipes.DRYING);
    private final int[] dryingTimes = new int[4];
    private final int[] dryingTotalTimes = new int[4];

    public DryingRackBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.DRYING_RACK_BLOCK_ENTITY, pos, state);
    }

    public class_2371<class_1799> getItemsBeingDrying() {
        return this.itemsBeingDrying;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DryingRackBlockEntity blockEntity) {
        if (!world.method_8530()) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < blockEntity.itemsBeingDrying.size(); ++i) {
            class_1799 itemStack = (class_1799)blockEntity.itemsBeingDrying.get(i);
            if (itemStack.method_7960() || blockEntity.dryingTimes[i] >= blockEntity.dryingTotalTimes[i]) continue;
            bl = true;
            blockEntity.dryingTimes[i] = blockEntity.dryingTimes[i] + 1;
            if (blockEntity.dryingTimes[i] < blockEntity.dryingTotalTimes[i]) continue;
            class_1799 itemStack2 = ((DryingRecipe)blockEntity.matchGetter.method_42303((class_1263)new class_1277(new class_1799[]{itemStack}), world).get()).method_8110().method_7972();
            blockEntity.itemsBeingDrying.set(i, (Object)itemStack2);
            world.method_8413(pos, state, state, 3);
        }
        if (bl) {
            DryingRackBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public Optional<DryingRecipe> getRecipeFor(class_1799 stack) {
        if (this.itemsBeingDrying.stream().noneMatch(class_1799::method_7960)) {
            return Optional.empty();
        }
        return this.matchGetter.method_42303((class_1263)new class_1277(new class_1799[]{stack}), this.field_11863);
    }

    public boolean addItem(class_1799 stack, int cookTime, int slot) {
        class_1799 itemStack = (class_1799)this.itemsBeingDrying.get(slot);
        if (!itemStack.method_7960()) {
            return false;
        }
        this.dryingTotalTimes[slot] = cookTime;
        this.dryingTimes[slot] = 0;
        this.itemsBeingDrying.set(slot, (Object)stack.method_7971(1));
        this.updateListeners();
        return true;
    }

    public boolean getItem(@Nullable class_1657 user, int slot) {
        class_1799 itemStack = (class_1799)this.itemsBeingDrying.get(slot);
        if (itemStack.method_7960()) {
            return false;
        }
        if (user != null) {
            user.method_31548().method_7394(itemStack);
        }
        this.itemsBeingDrying.set(slot, (Object)class_1799.field_8037);
        this.updateListeners();
        return true;
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_11007(class_2487 nbt) {
        class_1262.method_5427((class_2487)nbt, this.itemsBeingDrying, (boolean)true);
        nbt.method_10539("DryingTimes", this.dryingTimes);
        nbt.method_10539("DryingTotalTimes", this.dryingTotalTimes);
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        int[] is;
        super.method_11014(nbt);
        this.itemsBeingDrying.clear();
        class_1262.method_5429((class_2487)nbt, this.itemsBeingDrying);
        if (nbt.method_10573("DryingTimes", 11)) {
            is = nbt.method_10561("DryingTimes");
            System.arraycopy(is, 0, this.dryingTimes, 0, Math.min(this.dryingTotalTimes.length, is.length));
        }
        if (nbt.method_10573("DryingTotalTimes", 11)) {
            is = nbt.method_10561("DryingTotalTimes");
            System.arraycopy(is, 0, this.dryingTotalTimes, 0, Math.min(this.dryingTotalTimes.length, is.length));
        }
    }

    @Nullable
    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5427((class_2487)nbtCompound, this.itemsBeingDrying, (boolean)true);
        return nbtCompound;
    }
}

