/*
 * Decompiled with CFR 0.152.
 */
package com.nanokulon.primalstage.blocks.entity;

import com.nanokulon.primalstage.init.ModBlockEntities;
import com.nanokulon.primalstage.init.ModRecipes;
import com.nanokulon.primalstage.recipes.GrillRecipe;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PrimitiveGrillBlockEntity
extends class_2586 {
    private final class_2371<class_1799> itemsBeingCooked = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final class_1863.class_7266<class_1263, GrillRecipe> matchGetter = class_1863.method_42302(ModRecipes.GRILL);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];

    public PrimitiveGrillBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.PRIMITIVE_GRILL_BLOCK_ENTITY, pos, state);
    }

    public class_2371<class_1799> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PrimitiveGrillBlockEntity blockEntity) {
        if (!blockEntity.isLit(world, pos)) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < blockEntity.itemsBeingCooked.size(); ++i) {
            class_1799 itemStack = (class_1799)blockEntity.itemsBeingCooked.get(i);
            if (itemStack.method_7960() || blockEntity.cookingTimes[i] >= blockEntity.cookingTotalTimes[i]) continue;
            bl = true;
            blockEntity.cookingTimes[i] = blockEntity.cookingTimes[i] + 1;
            if (blockEntity.cookingTimes[i] < blockEntity.cookingTotalTimes[i]) continue;
            class_1799 itemStack2 = ((GrillRecipe)blockEntity.matchGetter.method_42303((class_1263)new class_1277(new class_1799[]{itemStack}), world).get()).getOutput().method_7854().method_7972();
            blockEntity.itemsBeingCooked.set(i, (Object)itemStack2);
            world.method_8413(pos, state, state, 3);
        }
        if (bl) {
            PrimitiveGrillBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public boolean isLit(class_1937 world, class_2338 pos) {
        return world.method_8320(pos.method_10087(1)).method_26204().equals(class_2246.field_10036);
    }

    public Optional<GrillRecipe> getRecipeFor(class_1799 stack) {
        if (this.itemsBeingCooked.stream().noneMatch(class_1799::method_7960)) {
            return Optional.empty();
        }
        return this.matchGetter.method_42303((class_1263)new class_1277(new class_1799[]{stack}), this.field_11863);
    }

    public boolean addItem(class_1799 stack, int cookTime, int slot) {
        class_1799 itemStack = (class_1799)this.itemsBeingCooked.get(slot);
        if (!itemStack.method_7960()) {
            return false;
        }
        this.cookingTotalTimes[slot] = cookTime;
        this.cookingTimes[slot] = 0;
        this.itemsBeingCooked.set(slot, (Object)stack.method_7971(1));
        this.updateListeners();
        return true;
    }

    public boolean getItem(@Nullable class_1657 user, int slot) {
        class_1799 itemStack = (class_1799)this.itemsBeingCooked.get(slot);
        if (itemStack.method_7960()) {
            return false;
        }
        if (user != null) {
            user.method_31548().method_7394(itemStack);
        }
        this.itemsBeingCooked.set(slot, (Object)class_1799.field_8037);
        this.updateListeners();
        return true;
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_11007(class_2487 nbt) {
        class_1262.method_5427((class_2487)nbt, this.itemsBeingCooked, (boolean)true);
        nbt.method_10539("CookingTimes", this.cookingTimes);
        nbt.method_10539("CookingTotalTimes", this.cookingTotalTimes);
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        int[] is;
        super.method_11014(nbt);
        this.itemsBeingCooked.clear();
        class_1262.method_5429((class_2487)nbt, this.itemsBeingCooked);
        if (nbt.method_10573("CookingTimes", 11)) {
            is = nbt.method_10561("CookingTimes");
            System.arraycopy(is, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
        if (nbt.method_10573("CookingTotalTimes", 11)) {
            is = nbt.method_10561("CookingTotalTimes");
            System.arraycopy(is, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
    }

    @Nullable
    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5427((class_2487)nbtCompound, this.itemsBeingCooked, (boolean)true);
        return nbtCompound;
    }
}

