/*
 * Decompiled with CFR 0.152.
 */
package traben.solid_mobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import traben.solid_mobs.SolidMobsCrossPlatformHelper;
import traben.solid_mobs.client.SolidMobsClient;
import traben.solid_mobs.config.SolidMobsConfig;

public class SolidMobsMain {
    public static SolidMobsConfig solidMobsConfigData;
    public static HashSet<String> EXEMPT_ENTITIES;
    public static final class_2960 SERVER_CONFIG_PACKET_ID;
    public static final HashMap<UUID, Long> LAST_PUSH_TIME;
    public static final Object2BooleanOpenHashMap<class_1299<?>> EXEMPT_CACHE;
    public static final Object2BooleanLinkedOpenHashMap<CollisionEvent> COLLISION_HISTORY;

    public static void init() {
        SolidMobsMain.sm$loadConfig();
    }

    public static void resetExemptions() {
        EXEMPT_CACHE.clear();
        COLLISION_HISTORY.clear();
        EXEMPT_ENTITIES.clear();
        EXEMPT_ENTITIES.add(class_1299.field_6059.toString());
        if (!SolidMobsMain.solidMobsConfigData.allowItemCollisions) {
            EXEMPT_ENTITIES.add(class_1299.field_6052.toString());
        }
        EXEMPT_ENTITIES.add(class_1299.field_6122.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6135.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6083.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6044.toString());
        if (!SolidMobsMain.solidMobsConfigData.allowVillagerCollisions) {
            EXEMPT_ENTITIES.add(class_1299.field_6077.toString());
        }
        if (!SolidMobsMain.solidMobsConfigData.allowPetCollisions) {
            EXEMPT_ENTITIES.add(class_1299.field_6055.toString());
            EXEMPT_ENTITIES.add(class_1299.field_16281.toString());
            EXEMPT_ENTITIES.add(class_1299.field_6104.toString());
        }
        EXEMPT_ENTITIES.add(class_1299.field_6116.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6045.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6144.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6082.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6064.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6061.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6124.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6100.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6135.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6068.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6127.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6130.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6120.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6043.toString());
        EXEMPT_ENTITIES.add(class_1299.field_28401.toString());
        EXEMPT_ENTITIES.add(class_1299.field_6089.toString());
        EXEMPT_ENTITIES.add(class_1299.field_33456.toString());
        EXEMPT_ENTITIES.add(class_1299.field_42460.toString());
        EXEMPT_ENTITIES.add(class_1299.field_42456.toString());
        EXEMPT_ENTITIES.add(class_1299.field_42457.toString());
        EXEMPT_ENTITIES.add(class_1299.field_42623.toString());
        EXEMPT_ENTITIES.addAll(Arrays.asList(SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist));
        String player = class_1299.field_6097.toString();
        if (EXEMPT_ENTITIES.contains(player)) {
            EXEMPT_ENTITIES.removeIf(val -> Objects.equals(val, player));
        }
    }

    public static boolean isExemptEntity(class_1297 entity) {
        return SolidMobsMain.isExemptType(entity.method_5864());
    }

    public static boolean isExemptType(class_1299<?> entityType) {
        if (EXEMPT_CACHE.containsKey(entityType)) {
            return EXEMPT_CACHE.getBoolean(entityType);
        }
        boolean value = EXEMPT_ENTITIES.contains(entityType.toString());
        EXEMPT_CACHE.put(entityType, value);
        return value;
    }

    public static void sm$loadConfig() {
        SolidMobsClient.haveServerConfig = false;
        File config = new File(SolidMobsCrossPlatformHelper.getConfigDirectory().toFile(), "solid_mobs.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (config.exists()) {
            try {
                FileReader fileReader = new FileReader(config);
                solidMobsConfigData = (SolidMobsConfig)gson.fromJson((Reader)fileReader, SolidMobsConfig.class);
                fileReader.close();
            }
            catch (IOException iOException) {}
        } else {
            solidMobsConfigData = new SolidMobsConfig();
        }
        SolidMobsMain.saveConfig();
        SolidMobsMain.resetExemptions();
    }

    public static void saveConfig() {
        if (!SolidMobsClient.haveServerConfig) {
            File config = new File(SolidMobsCrossPlatformHelper.getConfigDirectory().toFile(), "solid_mobs.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (!config.getParentFile().exists()) {
                config.getParentFile().mkdirs();
            }
            try {
                FileWriter fileWriter = new FileWriter(config);
                fileWriter.write(gson.toJson((Object)solidMobsConfigData));
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void registerCollisionOnServer(String entity1, String entity2, boolean result) {
        CollisionEvent lastKey;
        CollisionEvent event = new CollisionEvent(entity1, entity2);
        if (COLLISION_HISTORY.size() > 64 && !event.equals(lastKey = (CollisionEvent)COLLISION_HISTORY.lastKey())) {
            COLLISION_HISTORY.removeBoolean((Object)lastKey);
        }
        COLLISION_HISTORY.putAndMoveToFirst((Object)event, result);
    }

    static {
        EXEMPT_ENTITIES = new HashSet();
        SERVER_CONFIG_PACKET_ID = new class_2960("traben_solid_mobs:server_config_packet");
        LAST_PUSH_TIME = new HashMap();
        EXEMPT_CACHE = new Object2BooleanOpenHashMap();
        COLLISION_HISTORY = new Object2BooleanLinkedOpenHashMap();
    }

    public record CollisionEvent(String first, String second) {
        @Override
        public String toString() {
            return "[" + this.first + " -> " + this.second + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollisionEvent that = (CollisionEvent)o;
            return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) || Objects.equals(this.second, that.first) && Objects.equals(this.first, that.second);
        }

        @Override
        public int hashCode() {
            return this.first.hashCode() + this.second.hashCode();
        }
    }
}

