/*
 * Decompiled with CFR 0.152.
 */
package traben.solid_mobs.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import traben.solid_mobs.SolidMobsCrossPlatformHelper;
import traben.solid_mobs.SolidMobsMain;
import traben.solid_mobs.config.SolidMobsConfig;

public class SolidMobsCommands {
    private static final CommandExceptionType exception = new CommandExceptionType(){};

    private static CommandSyntaxException commandException(String str) {
        return new CommandSyntaxException(exception, () -> str);
    }

    public static int blacklistAdd(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String add = (String)context.getArgument("text", String.class);
            HashSet<String> list = new HashSet<String>(List.of(SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist));
            list.add(add);
            SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist = list.toArray(new String[0]);
            SolidMobsMain.saveConfig();
            SolidMobsMain.resetExemptions();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
            SolidMobsCommands.sendCommandFeedback(context, " [" + add + "] has been added to the collision blacklist.");
            return 1;
        }
        catch (Exception e) {
            throw SolidMobsCommands.commandException(e.getMessage());
        }
    }

    public static int blacklistRemove(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String remove = (String)context.getArgument("text", String.class);
            HashSet<String> list = new HashSet<String>(List.of(SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist));
            list.remove(remove);
            SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist = list.toArray(new String[0]);
            SolidMobsMain.saveConfig();
            SolidMobsMain.resetExemptions();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
            SolidMobsCommands.sendCommandFeedback(context, " [" + remove + "] has been removed from the collision blacklist.");
            return 1;
        }
        catch (Exception e) {
            throw SolidMobsCommands.commandException(e.getMessage());
        }
    }

    public static int blacklistClear(CommandContext<class_2168> context) {
        Object[] held = SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist;
        SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist = new String[0];
        SolidMobsMain.saveConfig();
        SolidMobsMain.resetExemptions();
        ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
        SolidMobsCommands.sendCommandFeedback(context, "The collision blacklist has been cleared, it was: " + Arrays.toString(held));
        return 1;
    }

    public static int blacklistList(CommandContext<class_2168> context) {
        SolidMobsCommands.sendCommandFeedback(context, "The HARDCODED collision blacklist (set by the settings or the dev): " + SolidMobsMain.EXEMPT_ENTITIES.toString() + "\n\u00a77_____________________________\u00a7r\nThe Custom collision blacklist (set by you): " + Arrays.toString(SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist));
        return 1;
    }

    public static int recentCollisionsQueryAll(CommandContext<class_2168> context) {
        StringBuilder builder = new StringBuilder();
        SolidMobsMain.COLLISION_HISTORY.forEach((key, val) -> builder.append(key.toString()).append("\n - mod triggered a collision: ").append(val != false ? "yes.\n" : "no.\n"));
        SolidMobsCommands.sendCommandFeedback(context, "All recent interactions:\n" + builder);
        return 1;
    }

    public static int recentCollisionsQueryPlayers(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String player = class_1299.field_6097.toString();
            StringBuilder builder = new StringBuilder();
            SolidMobsMain.COLLISION_HISTORY.forEach((collision, val) -> {
                if (player.equals(collision.first()) || player.equals(collision.second())) {
                    builder.append(collision).append("\n - mod triggered a collision: ").append(val != false ? "yes.\n" : "no.\n");
                }
            });
            SolidMobsCommands.sendCommandFeedback(context, "All recent interactions involving players:\n" + builder);
            return 1;
        }
        catch (Exception e) {
            throw SolidMobsCommands.commandException(e.getMessage());
        }
    }

    public static int recentCollisionsQueryYes(CommandContext<class_2168> context) {
        return SolidMobsCommands.collisionQueryYesNo(context, true);
    }

    public static int recentCollisionsQueryNo(CommandContext<class_2168> context) {
        return SolidMobsCommands.collisionQueryYesNo(context, false);
    }

    private static int collisionQueryYesNo(CommandContext<class_2168> context, boolean mustCollide) {
        StringBuilder builder = new StringBuilder();
        SolidMobsMain.COLLISION_HISTORY.forEach((key, val) -> {
            if (val == mustCollide) {
                builder.append(key.toString()).append("\n - ").append(mustCollide ? "mod triggered a collision" : "mod did not trigger a collision").append("!.\n");
            }
        });
        SolidMobsCommands.sendCommandFeedback(context, "All recent interactions:\n" + builder);
        return 1;
    }

    public static int resetAllSettings(CommandContext<class_2168> context) {
        SolidMobsMain.solidMobsConfigData = new SolidMobsConfig();
        SolidMobsMain.saveConfig();
        ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
        SolidMobsCommands.sendCommandFeedback(context, "Solid Mobs server config reset to defaults.");
        return 1;
    }

    public static int runBooleanConfigCommand(CommandContext<class_2168> context, Consumer<Boolean> setter) throws CommandSyntaxException {
        try {
            Boolean bool = (Boolean)context.getArgument("set", Boolean.class);
            setter.accept(bool);
            SolidMobsMain.saveConfig();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
            SolidMobsCommands.returnMessageValue(context, bool, "Setting successfully changed.");
            return 1;
        }
        catch (IllegalArgumentException e) {
            throw SolidMobsCommands.commandException(e.getMessage());
        }
    }

    public static int runFloatConfigCommand(CommandContext<class_2168> context, Consumer<Float> setter) throws CommandSyntaxException {
        try {
            Float aFloat = (Float)context.getArgument("set", Float.class);
            setter.accept(aFloat);
            SolidMobsMain.saveConfig();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
            SolidMobsCommands.returnMessageValue(context, aFloat, "Setting successfully changed.");
            return 1;
        }
        catch (IllegalArgumentException e) {
            throw SolidMobsCommands.commandException(e.getMessage());
        }
    }

    public static int runIntConfigCommand(CommandContext<class_2168> context, Consumer<Integer> setter) throws CommandSyntaxException {
        try {
            Integer integer = (Integer)context.getArgument("set", Integer.class);
            setter.accept(integer);
            SolidMobsMain.saveConfig();
            ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(SolidMobsCrossPlatformHelper::sendConfigToClient);
            SolidMobsCommands.returnMessageValue(context, integer, "Setting successfully changed.");
            return 1;
        }
        catch (IllegalArgumentException e) {
            throw SolidMobsCommands.commandException(e.getMessage());
        }
    }

    public static int returnMessageValue(CommandContext<class_2168> context, Object val, String info) {
        SolidMobsCommands.sendCommandFeedback(context, info + "\n\u00a7a\u00a7o - current value: " + val + "\u00a7r");
        return 1;
    }

    public static int printSettings(CommandContext<class_2168> context) {
        SolidMobsCommands.sendCommandFeedback(context, SolidMobsMain.solidMobsConfigData.toString());
        return 1;
    }

    private static void sendCommandFeedback(CommandContext<class_2168> context, String text) {
        String inputCommand = context.getInput();
        ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)("\n\u00a77\u00a7o/" + inputCommand + "\u00a7r\n" + text + "\n\u00a77_____________________________")));
    }

    private static int help(CommandContext<class_2168> context) {
        SolidMobsCommands.sendCommandFeedback(context, "\u00a7c\u00a7lSolids Mobs, command help:\u00a7r\n\n\u00a7a\u00a7o~listRecentCollisions\u00a7r - Displays a list of recent entity collisions the mod has been involved with, and their outcomes.\n\n\u00a7a\u00a7o~entityBlacklist\u00a7r  - Allows modification of the entity blacklist (entities that will not be modified by the mod). Entity names for these commands can be found using \"getRecentCollisions\".\n\n\u00a7a\u00a7o~settings <setting>\u00a7r  - Allows modification of all server side settings. Must be a server Operator or be in Single-Player. Each setting will explain what is does if you run it without setting a value.");
        return 1;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 ignoredRegistryAccess, class_2170.class_5364 ignoredEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"solid_mobs").requires(source -> source.method_9259(4) || source.method_9211().method_3724() && source.method_44023() != null && source.method_9211().method_19466(source.method_44023().method_7334()))).executes(SolidMobsCommands::help)).then(class_2170.method_9247((String)"help").executes(SolidMobsCommands::help))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listRecentCollisions").executes(SolidMobsCommands::recentCollisionsQueryAll)).then(class_2170.method_9247((String)"all").executes(SolidMobsCommands::recentCollisionsQueryAll))).then(class_2170.method_9247((String)"involvingPlayers").executes(SolidMobsCommands::recentCollisionsQueryPlayers))).then(class_2170.method_9247((String)"resultCollision").executes(SolidMobsCommands::recentCollisionsQueryYes))).then(class_2170.method_9247((String)"resultNoCollision").executes(SolidMobsCommands::recentCollisionsQueryNo)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"entityBlacklist").executes(SolidMobsCommands::blacklistList)).then(class_2170.method_9247((String)"list").executes(SolidMobsCommands::blacklistList))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(SolidMobsCommands::blacklistAdd)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.string()).executes(SolidMobsCommands::blacklistRemove)))).then(class_2170.method_9247((String)"clear").executes(SolidMobsCommands::blacklistClear)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").executes(SolidMobsCommands::printSettings)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"slimesAreBouncy").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.bouncySlimes, "Sets whether or not Slimes & Magma cubes cause you to bounce like the blocks."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.bouncySlimes = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"platformMode").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.platformMode, "If 'true' mobs will only be solid when walking on top of them.\n You can also press crouch to fall through them like platforms."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.platformMode = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canShoveMobs").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowShovingMobs, "Sets whether or not you can shove mobs, mobs can be shoved by crouching and right clicking them.\nThis allows you to get un-stuck when crammed in by a mob.\nBeware neutral mobs may get mad after being shoved.\nThe cooldown between shoving attempts can be set with the 'shovingMobsCoolDownTicks' setting"))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowShovingMobs = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canItemsCollide").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowItemCollisions, "Sets whether or not Items on the ground are made solid."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowItemCollisions = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canPlayersCollide").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowPlayerCollisions, "Sets whether or not players can collide with other players."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowPlayerCollisions = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canPetsCollide").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowPetCollisions, "Sets whether or not pet mobs collide. E.G. if you don't want your dog getting in your way."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowPetCollisions = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canVillagersCollide").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowVillagerCollisions, "Sets whether or not Villagers can collide."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowVillagerCollisions = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canInvisibleMobsCollide").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowInvisibleCollisions, "Sets whether or not invisible mobs will still collide."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowInvisibleCollisions = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canFallDamageBeSharedWithLandedOnMobs").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.fallDamageSharedWithLandedOnMob, "If 'true' then a percentage of fall damage is absorbed by any mob you fall onto.\nThis percentage can be set via the 'fallDamagePercentageSharedWithLandedOnMob' setting."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.fallDamageSharedWithLandedOnMob = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"canNonSavingEntitesCollide").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, SolidMobsMain.solidMobsConfigData.allowNonSavingEntityCollisions, "Sets whether or not Null/Unsaved entities can collide. Typically these might be decorative or logical entities depending on the mod."))).then(class_2170.method_9244((String)"set", (ArgumentType)BoolArgumentType.bool()).executes(context -> SolidMobsCommands.runBooleanConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.allowNonSavingEntityCollisions = val;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fallDamagePercentageSharedWithLandedOnMob").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, Float.valueOf(SolidMobsMain.solidMobsConfigData.fallDamageAmountAbsorbedByLandedOnMob), "If 'canFallDamageBeSharedWithLandedOnMobs' is enabled, this sets the percentage of fall damage shared with the other mob.\n0.5 = 50/50 split of the damage.\n0.75 = 25% fall damage taken by the falling mob and 75% damage taken by the mob being landed upon."))).then(class_2170.method_9244((String)"set", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(context -> SolidMobsCommands.runFloatConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.fallDamageAmountAbsorbedByLandedOnMob = val.floatValue();
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"shovingMobsCoolDownTicks").executes(context -> SolidMobsCommands.returnMessageValue((CommandContext<class_2168>)context, Float.valueOf(SolidMobsMain.solidMobsConfigData.fallDamageAmountAbsorbedByLandedOnMob), "Sets the time in ticks between players being able to shove mobs.\n20 ticks = 1 second."))).then(class_2170.method_9244((String)"set", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9999999)).executes(context -> SolidMobsCommands.runIntConfigCommand((CommandContext<class_2168>)context, val -> {
            SolidMobsMain.solidMobsConfigData.fallDamageAmountAbsorbedByLandedOnMob = val.intValue();
        }))))).then(class_2170.method_9247((String)"resetAllSettings").executes(SolidMobsCommands::resetAllSettings))).then(class_2170.method_9247((String)"listAllSettings").executes(SolidMobsCommands::printSettings))));
    }
}

