/*
 * Decompiled with CFR 0.152.
 */
package traben.solid_mobs.config;

import java.util.Arrays;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import traben.solid_mobs.client.SolidMobsClient;

public class SolidMobsConfig {
    public boolean platformMode = false;
    public boolean allowItemCollisions = false;
    public boolean allowNonSavingEntityCollisions = false;
    public boolean allowPlayerCollisions = true;
    public boolean allowPetCollisions = true;
    public boolean bouncySlimes = true;
    public boolean fallDamageSharedWithLandedOnMob = true;
    public float fallDamageAmountAbsorbedByLandedOnMob = 0.5f;
    public boolean allowInvisibleCollisions = false;
    public boolean allowShovingMobs = true;
    public int shoveAgainTimeInTicks = 20;
    public boolean allowVillagerCollisions = true;
    public String[] entityCollisionBlacklist = new String[]{"entity.ratsmischief.rat"};
    public static byte CONFIG_START_SYNC = (byte)-69;

    public float getFallAbsorbAmount() {
        if (this.fallDamageAmountAbsorbedByLandedOnMob > 1.0f) {
            return 1.0f;
        }
        if (this.fallDamageAmountAbsorbedByLandedOnMob < 0.0f) {
            return 0.0f;
        }
        return this.fallDamageAmountAbsorbedByLandedOnMob;
    }

    public void setFallAbsorbAmount(float set) {
        this.fallDamageAmountAbsorbedByLandedOnMob = set;
    }

    public boolean canUseMod(class_1937 world) {
        if (world == null) {
            return false;
        }
        if (world.field_9236) {
            if (class_310.method_1551().method_1542()) {
                return true;
            }
            return SolidMobsClient.haveServerConfig;
        }
        return true;
    }

    public String toString() {
        return "Solid Mobs, Settings:\n canItemsCollide=" + this.allowItemCollisions + "\n canPlayersCollide=" + this.allowPlayerCollisions + "\n canPetsCollide=" + this.allowPetCollisions + "\n slimesAreBouncy=" + this.bouncySlimes + "\n canFallDamageBeSharedWithLandedOnMobs=" + this.fallDamageSharedWithLandedOnMob + "\n fallDamagePercentageSharedWithLandedOnMob=" + this.fallDamageAmountAbsorbedByLandedOnMob + "\n canInvisibleMobsCollide=" + this.allowInvisibleCollisions + "\n canShoveMobs=" + this.allowShovingMobs + "\n shovingMobsCoolDownTicks=" + this.shoveAgainTimeInTicks + "\n canVillagersCollide=" + this.allowVillagerCollisions + "\n entityCollisionBlacklist=" + Arrays.toString(this.entityCollisionBlacklist);
    }

    public void encodeToByteBuffer(class_2540 buffer) {
        System.out.println("[Solid Mobs] - Encoding server config packet for client.");
        buffer.method_52997(0);
        buffer.method_52997((int)CONFIG_START_SYNC);
        buffer.method_52964(this.allowNonSavingEntityCollisions);
        buffer.method_52964(this.platformMode);
        buffer.method_52964(this.allowItemCollisions);
        buffer.method_52964(this.allowPlayerCollisions);
        buffer.method_52964(this.allowPetCollisions);
        buffer.method_52964(this.bouncySlimes);
        buffer.method_52964(this.fallDamageSharedWithLandedOnMob);
        buffer.method_52941(this.getFallAbsorbAmount());
        buffer.method_52964(this.allowInvisibleCollisions);
        buffer.method_52964(this.allowShovingMobs);
        buffer.method_53002(this.shoveAgainTimeInTicks);
        buffer.method_52964(this.allowVillagerCollisions);
        buffer.method_10814(Arrays.toString(this.entityCollisionBlacklist));
    }

    public SolidMobsConfig() {
    }

    public SolidMobsConfig(class_2540 buffer) {
        byte findMarker = buffer.readByte();
        while (findMarker != CONFIG_START_SYNC) {
            findMarker = buffer.readByte();
        }
        this.allowNonSavingEntityCollisions = buffer.readBoolean();
        this.platformMode = buffer.readBoolean();
        this.allowItemCollisions = buffer.readBoolean();
        this.allowPlayerCollisions = buffer.readBoolean();
        this.allowPetCollisions = buffer.readBoolean();
        this.bouncySlimes = buffer.readBoolean();
        this.fallDamageSharedWithLandedOnMob = buffer.readBoolean();
        this.setFallAbsorbAmount(buffer.readFloat());
        this.allowInvisibleCollisions = buffer.readBoolean();
        this.allowShovingMobs = buffer.readBoolean();
        this.shoveAgainTimeInTicks = buffer.readInt();
        this.allowVillagerCollisions = buffer.readBoolean();
        String read = buffer.method_19772();
        read = read.replaceFirst("^\\[", "").replaceFirst("]$", "");
        this.entityCollisionBlacklist = read.split(", ");
    }
}

