/*
 * Decompiled with CFR 0.152.
 */
package traben.solid_mobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import traben.solid_mobs.SolidMobsCrossPlatformHelper;
import traben.solid_mobs.client.SolidMobsClient;
import traben.solid_mobs.config.SolidMobsConfig;

public class SolidMobsMain {
    public static SolidMobsConfig solidMobsConfigData;
    public static HashSet<String> EXEMPT_ENTITIES;
    public static final ResourceLocation SERVER_CONFIG_PACKET_ID;
    public static final HashMap<UUID, Long> LAST_PUSH_TIME;
    public static final Object2BooleanOpenHashMap<EntityType<?>> EXEMPT_CACHE;
    public static final Object2BooleanLinkedOpenHashMap<CollisionEvent> COLLISION_HISTORY;

    public static void init() {
        SolidMobsMain.sm$loadConfig();
    }

    public static void resetExemptions() {
        EXEMPT_CACHE.clear();
        COLLISION_HISTORY.clear();
        EXEMPT_ENTITIES.clear();
        EXEMPT_ENTITIES.add(EntityType.f_20491_.toString());
        if (!SolidMobsMain.solidMobsConfigData.allowItemCollisions) {
            EXEMPT_ENTITIES.add(EntityType.f_20461_.toString());
        }
        EXEMPT_ENTITIES.add(EntityType.f_20548_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20478_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20476_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20570_.toString());
        if (!SolidMobsMain.solidMobsConfigData.allowVillagerCollisions) {
            EXEMPT_ENTITIES.add(EntityType.f_20492_.toString());
        }
        if (!SolidMobsMain.solidMobsConfigData.allowPetCollisions) {
            EXEMPT_ENTITIES.add(EntityType.f_20499_.toString());
            EXEMPT_ENTITIES.add(EntityType.f_20553_.toString());
            EXEMPT_ENTITIES.add(EntityType.f_20508_.toString());
        }
        EXEMPT_ENTITIES.add(EntityType.f_20565_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20486_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20483_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20484_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20485_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20571_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20467_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20522_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20478_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20477_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20487_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20498_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20506_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20462_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_147033_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_20450_.toString());
        EXEMPT_ENTITIES.add(EntityType.f_147036_.toString());
        EXEMPT_ENTITIES.addAll(Arrays.asList(SolidMobsMain.solidMobsConfigData.entityCollisionBlacklist));
        String player = EntityType.f_20532_.toString();
        if (EXEMPT_ENTITIES.contains(player)) {
            EXEMPT_ENTITIES.removeIf(val -> Objects.equals(val, player));
        }
    }

    public static boolean isExemptEntity(Entity entity) {
        return SolidMobsMain.isExemptType(entity.m_6095_());
    }

    public static boolean isExemptType(EntityType<?> entityType) {
        if (EXEMPT_CACHE.containsKey(entityType)) {
            return EXEMPT_CACHE.getBoolean(entityType);
        }
        boolean value = EXEMPT_ENTITIES.contains(entityType.toString());
        EXEMPT_CACHE.put(entityType, value);
        return value;
    }

    public static void sm$loadConfig() {
        SolidMobsClient.haveServerConfig = false;
        File config = new File(SolidMobsCrossPlatformHelper.getConfigDirectory().toFile(), "solid_mobs.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (config.exists()) {
            try {
                FileReader fileReader = new FileReader(config);
                solidMobsConfigData = (SolidMobsConfig)gson.fromJson((Reader)fileReader, SolidMobsConfig.class);
                fileReader.close();
            }
            catch (IOException iOException) {}
        } else {
            solidMobsConfigData = new SolidMobsConfig();
        }
        SolidMobsMain.saveConfig();
        SolidMobsMain.resetExemptions();
    }

    public static void saveConfig() {
        if (!SolidMobsClient.haveServerConfig) {
            File config = new File(SolidMobsCrossPlatformHelper.getConfigDirectory().toFile(), "solid_mobs.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (!config.getParentFile().exists()) {
                config.getParentFile().mkdirs();
            }
            try {
                FileWriter fileWriter = new FileWriter(config);
                fileWriter.write(gson.toJson((Object)solidMobsConfigData));
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void registerCollisionOnServer(String entity1, String entity2, boolean result) {
        CollisionEvent lastKey;
        CollisionEvent event = new CollisionEvent(entity1, entity2);
        if (COLLISION_HISTORY.size() > 64 && !event.equals(lastKey = (CollisionEvent)COLLISION_HISTORY.lastKey())) {
            COLLISION_HISTORY.removeBoolean((Object)lastKey);
        }
        COLLISION_HISTORY.putAndMoveToFirst((Object)event, result);
    }

    static {
        EXEMPT_ENTITIES = new HashSet();
        SERVER_CONFIG_PACKET_ID = new ResourceLocation("traben_solid_mobs:server_config_packet");
        LAST_PUSH_TIME = new HashMap();
        EXEMPT_CACHE = new Object2BooleanOpenHashMap();
        COLLISION_HISTORY = new Object2BooleanLinkedOpenHashMap();
    }

    public record CollisionEvent(String first, String second) {
        @Override
        public String toString() {
            return "[" + this.first + " -> " + this.second + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollisionEvent that = (CollisionEvent)o;
            return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) || Objects.equals(this.second, that.first) && Objects.equals(this.first, that.second);
        }

        @Override
        public int hashCode() {
            return this.first.hashCode() + this.second.hashCode();
        }
    }
}

