/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tlrts.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.tlrts.TlRtsMod;
import net.mcreator.tlrts.procedures.BarracksBuildProcedure;
import net.mcreator.tlrts.procedures.ExtractorBuildProcedure;
import net.mcreator.tlrts.procedures.FarmBuildProcedure;
import net.mcreator.tlrts.procedures.MagicBarracksBuildProcedure;
import net.mcreator.tlrts.procedures.MineshaftBuildProcedure;
import net.mcreator.tlrts.procedures.TowerBuildProcedure;
import net.mcreator.tlrts.world.inventory.BuildmenuMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BuildmenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public BuildmenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public BuildmenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(BuildmenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(BuildmenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            BuildmenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = BuildmenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MineshaftBuildProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            BarracksBuildProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            TowerBuildProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            FarmBuildProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            ExtractorBuildProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            MagicBarracksBuildProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TlRtsMod.addNetworkMessage(BuildmenuButtonMessage.class, BuildmenuButtonMessage::buffer, BuildmenuButtonMessage::new, BuildmenuButtonMessage::handler);
    }
}

