/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tlrts.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.tlrts.TlRtsMod;
import net.mcreator.tlrts.procedures.ButtonBackPressedProcedure;
import net.mcreator.tlrts.procedures.ColorfulPlaceProcedure;
import net.mcreator.tlrts.procedures.GlacialPlaceProcedure;
import net.mcreator.tlrts.procedures.MesaPlaceProcedure;
import net.mcreator.tlrts.procedures.PortalCombatPlaceProcedure;
import net.mcreator.tlrts.procedures.RuinsPlaceProcedure;
import net.mcreator.tlrts.procedures.ThreeDimensionsPlaceProcedure;
import net.mcreator.tlrts.procedures.ValleyPlaceProcedure;
import net.mcreator.tlrts.world.inventory.MapsGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MapsGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MapsGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MapsGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MapsGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MapsGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MapsGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = MapsGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ButtonBackPressedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ValleyPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            MesaPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            RuinsPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            GlacialPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            ThreeDimensionsPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            ColorfulPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            PortalCombatPlaceProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TlRtsMod.addNetworkMessage(MapsGuiButtonMessage.class, MapsGuiButtonMessage::buffer, MapsGuiButtonMessage::new, MapsGuiButtonMessage::handler);
    }
}

