/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.farmersrespite;

import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.mixin.accessors.farmersdelight.SyncedBlockEntityAccessor;
import dev.ghen.thirst.foundation.mixin.accessors.farmersrespite.KettleBlockEntityAccessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import umpaz.farmersrespite.common.block.entity.KettleBlockEntity;
import umpaz.farmersrespite.common.crafting.KettleRecipe;

@Mixin(value={KettleBlockEntity.class})
public abstract class MixinKettleBlockEntity {
    @Inject(method={"brewingTick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void brewingTickWithPurity(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle, CallbackInfo ci) {
        Optional<KettleRecipe> recipe;
        boolean isHeated = kettle.isHeated(level, pos);
        KettleBlockEntityAccessor kettleAcc = (KettleBlockEntityAccessor)kettle;
        if (isHeated && kettleAcc.invokeHasInput() && (recipe = kettleAcc.invokeGetMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)kettle.getInventory()))).isPresent() && kettleAcc.invokeCanBrew(recipe.get()) && WaterPurity.isWaterFilledContainer(recipe.get().m_8043_())) {
            ItemStack mealStack;
            boolean didInventoryChange = kettleAcc.invokeProcessBrewing(recipe.get(), kettle);
            if (didInventoryChange) {
                int purity = Math.min(WaterPurity.getBlockPurity(kettle.m_58900_()) + ((Number)CommonConfig.KETTLE_PURIFICATION_LEVELS.get()).intValue(), 3);
                kettle.getInventory().setStackInSlot(2, WaterPurity.addPurity(kettle.getInventory().getStackInSlot(2).m_41777_(), purity));
            }
            if (!(mealStack = kettle.getMeal()).m_41619_()) {
                if (!kettleAcc.invokeDoesMealHaveContainer(mealStack)) {
                    kettleAcc.invokeMoveMealToOutput();
                    didInventoryChange = true;
                } else if (!kettle.getInventory().getStackInSlot(3).m_41619_()) {
                    kettleAcc.invokeUseStoredContainersOnMeal();
                    didInventoryChange = true;
                }
            }
            if (didInventoryChange) {
                ((SyncedBlockEntityAccessor)kettle).invokeInventoryChanged();
            }
            ci.cancel();
        }
    }
}

