/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.compat.create;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.config.CommonConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class SandFilterTileEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int TANK_SIZE = 1000;
    SmartFluidTankBehaviour dirtyTank;
    SmartFluidTankBehaviour purifiedTank;

    public SandFilterTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.dirtyTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.dirtyTank);
        this.purifiedTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.purifiedTank);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, -2.0, 0.0);
    }

    private boolean trackFoods() {
        return ((AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side != null && side.m_122434_() == Direction.Axis.Y) {
            if (side == Direction.DOWN) {
                return this.purifiedTank.getCapability().cast();
            }
            return this.dirtyTank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_() && this.dirtyTank.getPrimaryHandler().getFluidAmount() >= ((Number)CommonConfig.SAND_FILTER_MB_PER_TICK.get()).intValue() && this.purifiedTank.getPrimaryHandler().getFluidAmount() < 1000) {
            FluidStack water = this.dirtyTank.getPrimaryHandler().drain(((Number)CommonConfig.SAND_FILTER_MB_PER_TICK.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
            if (WaterPurity.hasPurity(water)) {
                WaterPurity.addPurity(water, Math.min(WaterPurity.getPurity(water) + ((Number)CommonConfig.SAND_FILTER_FILTRATION_AMOUNT.get()).intValue(), 3));
            }
            this.purifiedTank.getPrimaryHandler().fill(water, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        int dirtyWaterAmount = this.dirtyTank.getPrimaryHandler().getFluidAmount();
        int purifiedWaterAmount = this.purifiedTank.getPrimaryHandler().getFluidAmount();
        this.buildTooltip(tooltip, mb, dirtyWaterAmount, this.dirtyTank);
        this.buildTooltip(tooltip, mb, purifiedWaterAmount, this.purifiedTank);
        if (this.dirtyTank.isEmpty() && this.purifiedTank.isEmpty()) {
            Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)this.dirtyTank.getPrimaryHandler().getTankCapacity(0)).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        }
        return !this.dirtyTank.isEmpty() || !this.purifiedTank.isEmpty();
    }

    private void buildTooltip(List<Component> tooltip, LangBuilder mb, int purifiedWaterAmount, SmartFluidTankBehaviour purifiedTank) {
        if (!purifiedTank.isEmpty()) {
            Lang.builder().text(WaterPurity.getPurityText(WaterPurity.getPurity(purifiedTank.getPrimaryHandler().getFluid()))).add(Lang.text((String)" ")).add(Lang.fluidName((FluidStack)purifiedTank.getPrimaryHandler().getFluid())).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.builder().add(Lang.number((double)purifiedWaterAmount).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)purifiedTank.getPrimaryHandler().getCapacity()).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
    }
}

