/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddLootTableModifier
extends LootModifier {
    private final ResourceLocation lootTable;

    protected AddLootTableModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        LootTable extraTable = context.m_78940_(this.lootTable);
        Objects.requireNonNull(generatedLoot);
        extraTable.m_79148_(context, generatedLoot::add);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddLootTableModifier> {
        public AddLootTableModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"lootTable"));
            return new AddLootTableModifier(conditions, lootTable);
        }

        public JsonObject write(AddLootTableModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("lootTable", instance.lootTable.toString());
            return object;
        }
    }
}

