/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.gui.appleskin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.foundation.gui.ThirstBarRenderer;
import dev.ghen.thirst.foundation.gui.appleskin.ThirstValues;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import squeek.appleskin.ModConfig;
import squeek.appleskin.helpers.KeyHelper;

@OnlyIn(value=Dist.CLIENT)
public class TooltipOverlayHandler {
    private static final ResourceLocation modIcons = new ResourceLocation("thirst", "textures/gui/appleskin_icons.png");
    private static final TextureOffsets normalBarTextureOffsets = new TextureOffsets();
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
        MinecraftForgeClient.registerTooltipComponentFactory(FoodTooltip.class, FoodTooltipRenderer::new);
    }

    @SubscribeEvent
    public void gatherTooltips(RenderTooltipEvent.GatherComponents event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack hoveredStack = event.getItemStack();
        Minecraft mc = Minecraft.m_91087_();
        if (TooltipOverlayHandler.shouldShowTooltip(hoveredStack, (Player)mc.f_91074_)) {
            return;
        }
        ThirstValues thirstValues = new ThirstValues(ThirstHelper.getThirst(hoveredStack), ThirstHelper.getQuenched(hoveredStack));
        FoodTooltip foodTooltip = new FoodTooltip(hoveredStack, thirstValues);
        if (foodTooltip.shouldRenderHungerBars()) {
            event.getTooltipElements().add(Either.right((Object)foodTooltip));
        }
    }

    private static boolean shouldShowTooltip(ItemStack hoveredStack, Player player) {
        boolean shouldShowTooltip;
        if (hoveredStack.m_41619_()) {
            return true;
        }
        boolean bl = shouldShowTooltip = (Boolean)ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP.get() != false && KeyHelper.isShiftKeyDown() || (Boolean)ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP.get() != false;
        if (!shouldShowTooltip) {
            return true;
        }
        return !ThirstHelper.itemRestoresThirst(hoveredStack);
    }

    static {
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 5;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    static class FoodTooltip
    implements TooltipComponent {
        private ThirstValues thirstValues;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private ItemStack itemStack;

        FoodTooltip(ItemStack itemStack, ThirstValues thirstValues) {
            this.itemStack = itemStack;
            this.thirstValues = thirstValues;
            this.hungerBars = (int)Math.ceil((float)Math.abs(thirstValues.thirst) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (thirstValues.thirst < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(thirstValues.quenchedModifier) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (thirstValues.quenchedModifier < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }

    static class FoodTooltipRenderer
    implements ClientTooltipComponent {
        private FoodTooltip foodTooltip;

        FoodTooltipRenderer(FoodTooltip foodTooltip) {
            this.foodTooltip = foodTooltip;
        }

        public int m_142103_() {
            return 20;
        }

        public int m_142069_(@NotNull Font font) {
            int hungerBarsWidth = this.foodTooltip.hungerBars * 9;
            if (this.foodTooltip.hungerBarsText != null) {
                hungerBarsWidth += font.m_92895_(this.foodTooltip.hungerBarsText);
            }
            int saturationBarsWidth = this.foodTooltip.saturationBars * 7;
            if (this.foodTooltip.saturationBarsText != null) {
                saturationBarsWidth += font.m_92895_(this.foodTooltip.saturationBarsText);
            }
            return Math.max(hungerBarsWidth, saturationBarsWidth) + 2;
        }

        public void m_183452_(@NotNull Font font, int x, int y, @NotNull PoseStack poseStack, @NotNull ItemRenderer itemRenderer_, int zIndex) {
            ItemStack itemStack = this.foodTooltip.itemStack;
            Minecraft mc = Minecraft.m_91087_();
            if (TooltipOverlayHandler.shouldShowTooltip(itemStack, (Player)mc.f_91074_)) {
                return;
            }
            Screen gui = mc.f_91080_;
            if (gui == null) {
                return;
            }
            ThirstValues thirstValues = this.foodTooltip.thirstValues;
            RenderSystem.m_69482_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            int offsetX = x;
            int offsetY = y;
            int thirst = thirstValues.thirst;
            offsetX += (this.foodTooltip.hungerBars - 1) * 9;
            RenderSystem.m_157456_((int)0, (ResourceLocation)ThirstBarRenderer.THIRST_ICONS);
            for (int i = 0; i < this.foodTooltip.hungerBars * 2; i += 2) {
                if (thirst == i + 1) {
                    GuiComponent.m_93143_((PoseStack)poseStack, (int)offsetX, (int)offsetY, (int)zIndex, (float)8.0f, (float)0.0f, (int)9, (int)9, (int)25, (int)9);
                } else {
                    GuiComponent.m_93143_((PoseStack)poseStack, (int)offsetX, (int)offsetY, (int)zIndex, (float)16.0f, (float)0.0f, (int)9, (int)9, (int)25, (int)9);
                }
                offsetX -= 9;
            }
            if (this.foodTooltip.hungerBarsText != null) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)(offsetX += 18), (double)offsetY, (double)zIndex);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                font.m_92756_(poseStack, this.foodTooltip.hungerBarsText, 2.0f, 2.0f, -5592406, false);
                poseStack.m_85849_();
            }
            offsetX = x;
            offsetY += 10;
            float modifiedSaturationIncrement = thirstValues.quenchedModifier;
            float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
            offsetX += (this.foodTooltip.saturationBars - 1) * 7;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)modIcons);
            for (int i = 0; i < this.foodTooltip.saturationBars * 2; i += 2) {
                boolean shouldBeFaded;
                float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
                boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
                if (shouldBeFaded) {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                GuiComponent.m_93143_((PoseStack)poseStack, (int)offsetX, (int)offsetY, (int)zIndex, (float)(effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f)))), (float)(modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f), (int)7, (int)7, (int)256, (int)256);
                if (shouldBeFaded) {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                offsetX -= 7;
            }
            if (this.foodTooltip.saturationBarsText != null) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)(offsetX += 14), (double)offsetY, (double)zIndex);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                font.m_92756_(poseStack, this.foodTooltip.saturationBarsText, 2.0f, 1.0f, -5592406, false);
                poseStack.m_85849_();
            }
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69465_();
        }
    }
}

