/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin;

import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.util.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BucketItem.class})
public class MixinBucketItem {
    private boolean shouldModify;
    private int purity;

    @Inject(method={"use"}, at={@At(value="HEAD")})
    public void setPurity(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        BlockPos blockPos = MathHelper.getPlayerPOVHitResult(player.m_183503_(), player, ClipContext.Fluid.SOURCE_ONLY).m_82425_();
        boolean bl = this.shouldModify = level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && level.m_6425_(blockPos).m_76170_();
        if (this.shouldModify) {
            this.purity = WaterPurity.getBlockPurity(level, blockPos);
        }
    }

    @ModifyArg(method={"use"}, index=2, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemUtils;createFilledResult(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack addPurity(ItemStack result) {
        if (this.shouldModify) {
            CompoundTag tag = result.m_41784_();
            tag.m_128405_("Purity", this.purity);
        }
        return result;
    }
}

