/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.brewinandchewin;

import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.mixin.accessors.brewinandchewin.KegBlockEntityAccessor;
import dev.ghen.thirst.foundation.mixin.accessors.farmersdelight.SyncedBlockEntityAccessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.crafting.KegRecipe;

@Mixin(value={KegBlockEntity.class})
public class MixinKegBlockEntity {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"fermentingTick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void brewingTickWithPurity(Level level, BlockPos pos, BlockState state, KegBlockEntity keg, CallbackInfo ci) {
        KegBlockEntityAccessor kegAcc = (KegBlockEntityAccessor)keg;
        keg.updateTemperature();
        if (!kegAcc.invokeHasInput()) return;
        Optional<KegRecipe> recipe = kegAcc.invokeGetMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)keg.getInventory()));
        if (!recipe.isPresent() || !kegAcc.invokeCanFerment(recipe.get()) || !WaterPurity.isWaterFilledContainer(recipe.get().m_8043_())) return;
        int purity = WaterPurity.getPurity(keg.getInventory().getStackInSlot(4));
        boolean didInventoryChange = kegAcc.invokeProcessFermenting(recipe.get(), keg);
        if (didInventoryChange) {
            purity = purity < ((Number)CommonConfig.FERMENTATION_MOLDING_THRESHOLD.get()).intValue() ? Math.max(purity - ((Number)CommonConfig.FERMENTATION_MOLDING_HARSHNESS.get()).intValue(), 0) : purity;
            keg.getInventory().setStackInSlot(5, WaterPurity.addPurity(keg.getInventory().getStackInSlot(5), purity));
        }
        ItemStack mealStack = keg.getDrink();
        if (!mealStack.m_41619_()) {
            if (!kegAcc.invokeDoesDrinkHaveContainer(mealStack)) {
                kegAcc.invokeMoveDrinkToOutput();
                didInventoryChange = true;
            } else if (!keg.getInventory().getStackInSlot(6).m_41619_()) {
                kegAcc.invokeUseStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            ((SyncedBlockEntityAccessor)keg).invokeInventoryChanged();
        }
        ci.cancel();
    }

    @Redirect(method={"processFermenting"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/items/ItemStackHandler;setStackInSlot(ILnet/minecraft/world/item/ItemStack;)V", ordinal=3), remap=false)
    private void AddPurityToInputFluid(ItemStackHandler instance, int slot, ItemStack stack) {
        ItemStack fluid_input = instance.getStackInSlot(4);
        fluid_input.m_41774_(1);
        instance.setStackInSlot(4, fluid_input);
    }

    @Redirect(method={"processFermenting"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/items/ItemStackHandler;setStackInSlot(ILnet/minecraft/world/item/ItemStack;)V", ordinal=5), remap=false)
    private void AddPurityToInputFluid_2(ItemStackHandler instance, int slot, ItemStack stack) {
        ItemStack fluid_input = instance.getStackInSlot(4);
        fluid_input.m_41774_(1);
        instance.setStackInSlot(4, fluid_input);
    }
}

