/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.purity;

import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.registry.ItemInit;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.util.MathHelper;
import dev.ghen.thirst.foundation.util.ReflectionUtil;
import dev.ghen.thirst.foundation.util.TickHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.item.TANItems;

@Mod.EventBusSubscriber
public class WaterPurity {
    private static final List<ContainerWithPurity> waterContainers = new ArrayList<ContainerWithPurity>();
    private static final List<Block> fillablesWithPurity = new ArrayList<Block>();
    public static final int MIN_PURITY = 0;
    public static final int MAX_PURITY = 3;
    public static final IntegerProperty BLOCK_PURITY = IntegerProperty.m_61631_((String)"purity", (int)0, (int)4);
    public static boolean tanLoaded = false;

    public static void init() {
        WaterPurity.registerDispenserBehaviours();
        WaterPurity.registerContainers();
        WaterPurity.registerFillables();
        if (ModList.get().isLoaded("farmersrespite")) {
            WaterPurity.registerFarmersRespiteContainers();
        }
        if (ModList.get().isLoaded("brewinandchewin")) {
            WaterPurity.registerBrewinAndChewinContainers();
        }
        if (ModList.get().isLoaded("collectorsreap")) {
            WaterPurity.registerCollectorsReapContainers();
        }
        if (ModList.get().isLoaded("toughasnails")) {
            WaterPurity.registerToughAsNailsContainers();
            tanLoaded = true;
        }
    }

    private static void registerContainers() {
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)Items.f_42590_), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)).setEqualsFilled(itemStack -> itemStack.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43599_));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)ItemInit.TERRACOTTA_BOWL.get()), new ItemStack((ItemLike)ItemInit.TERRACOTTA_WATER_BOWL.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)Items.f_42446_), new ItemStack((ItemLike)Items.f_42447_), false).canHarvestRunningWater(false));
    }

    private static void registerFillables() {
        fillablesWithPurity.add(Blocks.f_50256_);
        fillablesWithPurity.add(Blocks.f_152476_);
    }

    private static void registerCollectorsReapContainers() {
    }

    private static void registerFarmersRespiteContainers() {
    }

    private static void registerBrewinAndChewinContainers() {
    }

    private static void registerToughAsNailsContainers() {
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.PURIFIED_WATER_CANTEEN.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.DIRTY_WATER_CANTEEN.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.WATER_CANTEEN.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.PURIFIED_WATER_BOTTLE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.DIRTY_WATER_BOTTLE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.APPLE_JUICE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.CACTUS_JUICE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.CHORUS_FRUIT_JUICE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.GLOW_BERRY_JUICE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.MELON_JUICE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.PUMPKIN_JUICE.get())));
        waterContainers.add(new ContainerWithPurity(new ItemStack((ItemLike)TANItems.SWEET_BERRY_JUICE.get())));
    }

    @SubscribeEvent
    static void fillablesHandler(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Player player;
        Level level;
        BlockState blockState;
        if (event.getEntity() instanceof ServerPlayer && WaterPurity.isWaterFilledContainer(event.getItemStack()) && WaterPurity.isFillableBlock(blockState = (level = (player = event.getEntity()).m_9236_()).m_8055_(pos = event.getHitVec().m_82425_()))) {
            int purity = WaterPurity.getPurity(event.getItemStack());
            int blockPurity = !blockState.m_61138_((Property)BLOCK_PURITY) ? 3 : ((Integer)blockState.m_61143_((Property)BLOCK_PURITY) - 1 < 0 ? 3 : (Integer)blockState.m_61143_((Property)BLOCK_PURITY) - 1);
            TickHelper.nextTick(level, () -> {
                BlockState blockState1 = level.m_8055_(pos);
                level.m_7731_(pos, (BlockState)blockState1.m_61124_((Property)BLOCK_PURITY, (Comparable)Integer.valueOf(Math.min(purity, blockPurity) + 1)), 0);
            });
        }
    }

    public static void addContainer(ContainerWithPurity container) {
        waterContainers.add(container);
    }

    public static ItemStack getFilledContainer(ItemStack container, boolean fromFilled) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if ((fromFilled || !waterContainer.equalsEmpty(container)) && (!fromFilled || !waterContainer.equalsFilled(container))) continue;
            return waterContainer.getFilledItem().m_41777_();
        }
        return ItemStack.f_41583_.m_41777_();
    }

    @SubscribeEvent
    static void harvestRunningWater(PlayerInteractEvent.RightClickItem event) {
        BlockPos blockPos;
        Player player;
        Level level;
        ItemStack item;
        if (event.getEntity() != null && WaterPurity.canHarvestRunningWater(item = event.getItemStack()) && (level = (player = event.getEntity()).m_9236_()).m_6425_(blockPos = MathHelper.getPlayerPOVHitResult(level, player, ClipContext.Fluid.ANY).m_82425_()).m_205070_(FluidTags.f_13131_)) {
            ItemStack filledItem;
            SoundEvent sound;
            if (item.m_41720_() == Items.f_42590_ && !level.m_6425_(blockPos).m_76170_()) {
                sound = SoundEvents.f_11770_;
                filledItem = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
            } else if (item.m_41720_() == ItemInit.TERRACOTTA_BOWL.get()) {
                sound = SoundEvents.f_11781_;
                filledItem = new ItemStack((ItemLike)ItemInit.TERRACOTTA_WATER_BOWL.get());
            } else {
                return;
            }
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157816_, blockPos);
            CompoundTag tag = filledItem.m_41784_();
            tag.m_128405_("Purity", WaterPurity.getBlockPurity(level, blockPos));
            ItemStack result = ItemUtils.m_41813_((ItemStack)item, (Player)player, (ItemStack)filledItem);
            player.m_21008_(event.getHand(), result);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void renderPurityTooltip(ItemTooltipEvent event) {
        int purity;
        if (WaterPurity.isWaterFilledContainer(event.getItemStack()) && (purity = WaterPurity.getPurity(event.getItemStack())) >= 0 && purity <= 3) {
            String purityText = WaterPurity.getPurityText(purity);
            int purityColor = WaterPurity.getPurityColor(purity);
            assert (purityText != null);
            event.getToolTip().add(MutableComponent.m_237204_((ComponentContents)new LiteralContents(purityText)).m_6270_(Style.f_131099_.m_178520_(purityColor)));
        }
    }

    public static boolean isWaterFilledContainer(ItemStack item) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if (!waterContainer.equalsFilled(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyWaterContainer(ItemStack item) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if (!waterContainer.equalsEmpty(item)) continue;
            return true;
        }
        return false;
    }

    static boolean isFillableBlock(Block block) {
        Block fillable;
        Iterator<Block> var1 = fillablesWithPurity.iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while ((fillable = var1.next()) != block);
        return true;
    }

    static boolean isFillableBlock(BlockState blockState) {
        Block fillable;
        Iterator<Block> var1 = fillablesWithPurity.iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while (!blockState.m_60713_(fillable = var1.next()));
        return true;
    }

    static boolean canHarvestRunningWater(ItemStack item) {
        for (ContainerWithPurity waterContainer : waterContainers) {
            if (!waterContainer.equalsEmpty(item) || !waterContainer.canHarvestRunningWater()) continue;
            return true;
        }
        return false;
    }

    public static int getPurity(ItemStack item) {
        if (!item.m_41784_().m_128441_("Purity")) {
            item.m_41784_().m_128405_("Purity", -1);
            if (tanLoaded && Objects.equals(item.m_41720_().getCreatorModId(item), "toughasnails")) {
                WaterPurity.tanPurity(item);
            }
        }
        return Objects.requireNonNull(item.m_41783_()).m_128451_("Purity");
    }

    public static void tanPurity(ItemStack item) {
        assert (item.m_41783_() != null);
        item.m_41783_().m_128405_("Purity", 3);
        if (item.m_150930_((Item)TANItems.DIRTY_WATER_BOTTLE.get()) || item.m_150930_((Item)TANItems.DIRTY_WATER_CANTEEN.get())) {
            item.m_41783_().m_128405_("Purity", 0);
        }
        if (item.m_150930_((Item)TANItems.WATER_CANTEEN.get())) {
            item.m_41783_().m_128405_("Purity", 2);
        }
    }

    public static int getPurity(FluidStack fluid) {
        if (!fluid.getOrCreateTag().m_128441_("Purity")) {
            fluid.getOrCreateTag().m_128405_("Purity", -1);
        }
        return fluid.getTag().m_128451_("Purity");
    }

    public static String getPurityText(int purity) {
        if (purity == -1) {
            return null;
        }
        String purityText = purity == 0 ? "dirty" : (purity == 1 ? "slightly_dirty" : (purity == 2 ? "acceptable" : "purified"));
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents("thirst.purity." + purityText, purityText, TranslatableContents.f_237494_)).getString();
    }

    public static int getPurityColor(int purity) {
        return purity == 0 ? 11028517 : (purity == 1 ? 7957617 : (purity == 2 ? 6128285 : 2208255));
    }

    public static int getBlockPurity(BlockState blockState) {
        return blockState.m_61138_((Property)BLOCK_PURITY) ? (Integer)blockState.m_61143_((Property)BLOCK_PURITY) - 1 : -1;
    }

    public static boolean hasPurity(ItemStack item) {
        if (!item.m_41782_()) {
            return false;
        }
        assert (item.m_41783_() != null);
        return item.m_41783_().m_128441_("Purity");
    }

    public static boolean hasPurity(FluidStack fluid) {
        if (!fluid.hasTag()) {
            return false;
        }
        return fluid.getTag().m_128441_("Purity");
    }

    public static ItemStack addPurity(ItemStack item, BlockPos pos, Level level) {
        CompoundTag tag = item.m_41784_();
        tag.m_128405_("Purity", WaterPurity.getBlockPurity(level, pos));
        return item;
    }

    public static ItemStack addPurity(ItemStack item, int purity) {
        CompoundTag tag = item.m_41784_();
        tag.m_128405_("Purity", purity);
        return item;
    }

    public static FluidStack addPurity(FluidStack fluid, int purity) {
        CompoundTag tag = fluid.getOrCreateTag();
        tag.m_128405_("Purity", purity);
        return fluid;
    }

    public static int getBlockPurity(Level level, BlockPos pos) {
        int purity;
        int n = purity = (pos.m_123342_() > ((Number)CommonConfig.MOUNTAINS_Y.get()).intValue() || pos.m_123342_() < ((Number)CommonConfig.CAVES_Y.get()).intValue()) && pos.m_123342_() < ((Number)CommonConfig.MOUNTAINS_Y.get()).intValue() - 32 ? 1 : 0;
        if (level.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            if (!level.m_6425_(pos).m_76170_()) {
                purity = Math.min(purity + ((Number)CommonConfig.RUNNING_WATER_PURIFICATION_AMOUNT.get()).intValue(), 3);
            }
            return purity;
        }
        if (level.m_8055_(pos).m_60713_(Blocks.f_152476_)) {
            return (Integer)level.m_8055_(pos).m_61143_((Property)BLOCK_PURITY) - 1;
        }
        return -1;
    }

    public static boolean givePurityEffects(Player player, ItemStack item) {
        if (!WaterPurity.isWaterFilledContainer(item)) {
            return true;
        }
        if (!WaterPurity.hasPurity(item)) {
            return true;
        }
        if (WaterPurity.getPurity(item) != -1) {
            return WaterPurity.givePurityEffects(player, ThirstHelper.getPurity(item));
        }
        return WaterPurity.givePurityEffects(player, 0);
    }

    public static boolean givePurityEffects(Player player, int purity) {
        boolean shouldRegenerate = true;
        Random random = new Random();
        float chance = random.nextFloat();
        switch (purity) {
            case 0: {
                if (chance < (float)((Number)CommonConfig.DIRTY_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.DIRTY_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                }
                shouldRegenerate = false;
                break;
            }
            case 1: {
                if (chance < (float)((Number)CommonConfig.SLIGHTLY_DIRTY_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.SLIGHTLY_DIRTY_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                }
                shouldRegenerate = false;
                break;
            }
            case 2: {
                if (chance < (float)((Number)CommonConfig.ACCEPTABLE_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.ACCEPTABLE_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                }
                shouldRegenerate = false;
                break;
            }
            case 3: {
                if (chance < (float)((Number)CommonConfig.PURIFIED_NAUSEA_PERCENTAGE.get()).intValue() / 100.0f && player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 0));
                }
                if (!(chance <= (float)((Number)CommonConfig.PURIFIED_POISON_PERCENTAGE.get()).intValue() / 100.0f)) break;
                if (player instanceof ServerPlayer) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                }
                shouldRegenerate = false;
            }
        }
        return shouldRegenerate || (Boolean)CommonConfig.QUENCH_THIRST_WHEN_DEBUFFED.get() != false;
    }

    static void registerDispenserBehaviours() {
        Method getDispenseMethod = ObfuscationReflectionHelper.findMethod(DispenserBlock.class, (String)"m_7216_", (Class[])new Class[]{ItemStack.class});
        DispenseItemBehavior bucketDefaultBehaviour = (DispenseItemBehavior)ReflectionUtil.fuckYouReflections(getDispenseMethod, Blocks.f_50061_, new ItemStack((ItemLike)Items.f_42446_));
        OptionalDispenseItemBehavior bottleDefaultBehaviour = (OptionalDispenseItemBehavior)ReflectionUtil.fuckYouReflections(getDispenseMethod, Blocks.f_50061_, new ItemStack((ItemLike)Items.f_42590_));
        Method execute = ObfuscationReflectionHelper.findMethod(DefaultDispenseItemBehavior.class, (String)"m_7498_", (Class[])new Class[]{BlockSource.class, ItemStack.class});
        DispenserBlock.m_52672_((ItemLike)Items.f_42446_, (block, item) -> {
            BlockPos blockpos;
            ServerLevel level = block.m_7727_();
            if (level.m_6425_(blockpos = block.m_7961_().m_121945_((Direction)block.m_6414_().m_61143_((Property)DispenserBlock.f_52659_))).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockpos).m_60819_().m_76170_()) {
                ItemStack result = new ItemStack((ItemLike)Items.f_42447_);
                return WaterPurity.getStack(block, item, (Level)level, blockpos, result, true);
            }
            return (ItemStack)ReflectionUtil.fuckYouReflections(execute, bucketDefaultBehaviour, block, item);
        });
        DispenserBlock.m_52672_((ItemLike)Items.f_42590_, (block, item) -> {
            BlockPos blockpos;
            ServerLevel level = block.m_7727_();
            if (level.m_6425_(blockpos = block.m_7961_().m_121945_((Direction)block.m_6414_().m_61143_((Property)DispenserBlock.f_52659_))).m_205070_(FluidTags.f_13131_)) {
                ItemStack result = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                return WaterPurity.getStack(block, item, (Level)level, blockpos, result, false);
            }
            return (ItemStack)ReflectionUtil.fuckYouReflections(execute, bottleDefaultBehaviour, block, item);
        });
    }

    @NotNull
    private static ItemStack getStack(BlockSource block, ItemStack item, Level level, BlockPos blockpos, ItemStack result, boolean pickupBlock) {
        level.m_142346_(null, GameEvent.f_157816_, blockpos);
        WaterPurity.addPurity(result, blockpos, level);
        if (pickupBlock) {
            ((BucketPickup)level.m_8055_(blockpos).m_60734_()).m_142598_((LevelAccessor)level, blockpos, level.m_8055_(blockpos));
        }
        item.m_41774_(1);
        if (item.m_41619_()) {
            return result;
        }
        if (((DispenserBlockEntity)block.m_8118_()).m_59237_(result) < 0) {
            new DefaultDispenseItemBehavior().m_6115_(block, result);
        }
        return item;
    }
}

