/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.gui.appleskin;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ghen.thirst.Thirst;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModCapabilities;
import dev.ghen.thirst.foundation.gui.ThirstBarRenderer;
import dev.ghen.thirst.foundation.gui.appleskin.ThirstValues;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.util.IntPoint;

@OnlyIn(value=Dist.CLIENT)
public class HUDOverlayHandler {
    private static float unclampedFlashAlpha = 0.0f;
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    protected static int foodIconsOffset;
    public static final Vector<IntPoint> foodBarOffsets;
    private static final Random random;
    private static final ResourceLocation modIcons;
    static ResourceLocation THIRST_LEVEL_ELEMENT;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HUDOverlayHandler());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)THIRST_LEVEL_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            boolean isMounted = mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && ((Boolean)ModConfig.SHOW_FOOD_EXHAUSTION_UNDERLAY.get()).booleanValue()) {
                HUDOverlayHandler.renderExhaustion(gui, event.getGuiGraphics());
            }
        }
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)THIRST_LEVEL_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            boolean isMounted = mc.f_91074_.m_20202_() instanceof LivingEntity;
            if (!isMounted && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                HUDOverlayHandler.renderThirstOverlay(event.getGuiGraphics());
            }
        }
    }

    public static void renderExhaustion(ForgeGui gui, GuiGraphics mStack) {
        foodIconsOffset = gui.rightHeight;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        int right = mc.m_91268_().m_85445_() / 2 + 91;
        int top = mc.m_91268_().m_85446_() - foodIconsOffset;
        float exhaustion = ((IThirst)player.getCapability(ModCapabilities.PLAYER_THIRST).orElse(null)).getExhaustion();
        HUDOverlayHandler.drawExhaustionOverlay(exhaustion, mStack, right, top);
    }

    public static void renderThirstOverlay(GuiGraphics guiGraphics) {
        boolean shouldRenderHeldItemValues;
        if (!HUDOverlayHandler.shouldRenderAnyOverlays()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        IThirst thirstData = (IThirst)player.getCapability(ModCapabilities.PLAYER_THIRST).orElse(null);
        int top = mc.m_91268_().m_85446_() - foodIconsOffset;
        int right = mc.m_91268_().m_85445_() / 2 + 91;
        HUDOverlayHandler.generateHungerBarOffsets(top, right, mc.f_91065_.m_93079_(), (Player)player);
        HUDOverlayHandler.drawSaturationOverlay(0.0f, thirstData.getQuenched(), guiGraphics, right, top, 1.0f);
        ItemStack heldItem = player.m_21205_();
        if (!ThirstHelper.itemRestoresThirst(heldItem)) {
            heldItem = player.m_21206_();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.m_41619_() && ThirstHelper.itemRestoresThirst(heldItem);
        if (!shouldRenderHeldItemValues) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        ThirstValues thirstValues = new ThirstValues(ThirstHelper.getThirst(heldItem), ThirstHelper.getQuenched(heldItem));
        int drinkThirst = thirstValues.thirst;
        float thirstQuenchedIncrement = thirstValues.getQuenchedIncrement();
        if (thirstData.getThirst() < 20) {
            HUDOverlayHandler.drawHungerOverlay(drinkThirst, thirstData.getThirst(), guiGraphics, right, top, flashAlpha);
        }
        if (!ThirstHelper.isFood(heldItem) || player.m_36324_().m_38702_() < 20) {
            HUDOverlayHandler.drawSaturationOverlay(thirstValues.quenchedModifier, thirstData.getQuenched(), guiGraphics, right, top, flashAlpha);
        }
    }

    public static void drawSaturationOverlay(float saturationGained, float saturationLevel, GuiGraphics guiGraphics, int right, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)modIcons);
        float modifiedSaturation = Math.max(0.0f, Math.min(saturationLevel + saturationGained, 20.0f));
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = iconSize;
            }
            guiGraphics.m_280218_(modIcons, x, y, u, v, iconSize, iconSize);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ThirstBarRenderer.MC_ICONS);
        HUDOverlayHandler.disableAlpha();
    }

    public static void drawHungerOverlay(int hungerRestored, int foodLevel, GuiGraphics guiGraphics, int right, int top, float alpha) {
        if (hungerRestored <= 0) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ThirstBarRenderer.THIRST_ICONS);
        int modifiedFood = Math.max(0, Math.min(20, foodLevel + hungerRestored));
        int startFoodBars = Math.max(0, foodLevel / 2);
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 5;
        int iconSize = 9;
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 3 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            if (i * 2 + 1 == modifiedFood) {
                u -= iconSize - 1;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            guiGraphics.m_280163_(ThirstBarRenderer.THIRST_ICONS, x, y, (float)u, (float)v, iconSize, iconSize, 25, 9);
        }
        HUDOverlayHandler.disableAlpha();
    }

    public static void drawExhaustionOverlay(float exhaustion, GuiGraphics guiGraphics, int right, int top) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)modIcons);
        float maxExhaustion = 4.0f;
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        guiGraphics.m_280218_(modIcons, right - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ThirstBarRenderer.MC_ICONS);
    }

    public static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public static void disableAlpha() {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if ((unclampedFlashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            alphaDir = (byte)-1;
        } else if (unclampedFlashAlpha <= -0.5f) {
            alphaDir = 1;
        }
        flashAlpha = Math.max(0.0f, Math.min(1.0f, unclampedFlashAlpha)) * 0.65f;
    }

    public static void resetFlash() {
        flashAlpha = 0.0f;
        unclampedFlashAlpha = 0.0f;
        alphaDir = 1;
    }

    private static boolean shouldRenderAnyOverlays() {
        return true;
    }

    private static void generateHungerBarOffsets(int top, int right, int ticks, Player player) {
        boolean shouldAnimatedFood;
        int preferFoodBars = 10;
        IThirst thirstData = (IThirst)player.getCapability(ModCapabilities.PLAYER_THIRST).orElse(null);
        float quenched = thirstData.getQuenched();
        int thirst = thirstData.getThirst();
        boolean bl = shouldAnimatedFood = quenched <= 0.0f && ticks % (thirst * 3 + 1) == 0;
        if (foodBarOffsets.size() != 10) {
            foodBarOffsets.setSize(10);
        }
        for (int i = 0; i < 10; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += random.nextInt(3) - 1;
            }
            if ((point = foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }

    static {
        foodBarOffsets = new Vector();
        random = new Random();
        modIcons = Thirst.asResource("textures/gui/appleskin_icons.png");
        THIRST_LEVEL_ELEMENT = Thirst.asResource("thirst_level");
    }

    static enum RenderOverlayType {
        THIRST;

    }
}

