/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.foxgirl.trimeffects.TrimEffects;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import org.jetbrains.annotations.NotNull;

public final class Config {
    @NotNull
    public Map<String, String> effects = new LinkedHashMap<String, String>();
    @NotNull
    public Map<String, Integer> strengths = new LinkedHashMap<String, Integer>();
    private static final Config DEFAULT = new Config();
    private static final Gson GSON;

    @NotNull
    public Parsed parse() {
        return new Parsed(this);
    }

    @NotNull
    public static Config read() {
        Path pathDirectory = FabricLoaderImpl.INSTANCE.getConfigDir();
        Path pathFile = pathDirectory.resolve("trimeffects-config.json");
        Path pathTemp = pathDirectory.resolve("trimeffects-config.json.tmp");
        try {
            return (Config)GSON.fromJson((Reader)Files.newBufferedReader(pathFile), Config.class);
        }
        catch (NoSuchFileException cause) {
            TrimEffects.LOGGER.error("Failed to read config, file not found");
        }
        catch (IOException cause) {
            TrimEffects.LOGGER.error("Failed to read config, IO error", (Throwable)cause);
        }
        catch (JsonParseException cause) {
            TrimEffects.LOGGER.error("Failed to read config, JSON error", (Throwable)cause);
        }
        catch (Exception cause) {
            TrimEffects.LOGGER.error("Failed to read config", (Throwable)cause);
        }
        try {
            Files.writeString(pathTemp, (CharSequence)GSON.toJson((Object)DEFAULT), new OpenOption[0]);
            Files.move(pathTemp, pathFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException cause) {
            TrimEffects.LOGGER.error("Failed to write new config, IO error", (Throwable)cause);
        }
        catch (Exception cause) {
            TrimEffects.LOGGER.error("Failed to write new config", (Throwable)cause);
        }
        return DEFAULT;
    }

    static {
        Config.DEFAULT.effects.put("spire", "strength");
        Config.DEFAULT.effects.put("eye", "regeneration");
        Config.DEFAULT.effects.put("snout", "fire_resistance");
        Config.DEFAULT.effects.put("rib", "haste");
        Config.DEFAULT.effects.put("vex", "invisibility");
        Config.DEFAULT.effects.put("ward", "absorption");
        Config.DEFAULT.effects.put("tide", "luck");
        Config.DEFAULT.effects.put("wild", "hero_of_the_village");
        Config.DEFAULT.effects.put("coast", "water_breathing");
        Config.DEFAULT.effects.put("dune", "speed");
        Config.DEFAULT.effects.put("sentry", "resistance");
        Config.DEFAULT.effects.put("wayfinder", "jump_boost");
        Config.DEFAULT.effects.put("shaper", "saturation");
        Config.DEFAULT.effects.put("silence", "night_vision");
        Config.DEFAULT.effects.put("raiser", "saturation");
        Config.DEFAULT.effects.put("host", "glowing");
        Config.DEFAULT.strengths.put("diamond", 1);
        Config.DEFAULT.strengths.put("netherite", 2);
        GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();
    }

    public static final class Parsed {
        private final Map<class_5321<class_8056>, class_5321<class_1291>> effects = new LinkedHashMap<class_5321<class_8056>, class_5321<class_1291>>();
        private final Map<class_5321<class_8054>, Integer> strengths = new LinkedHashMap<class_5321<class_8054>, Integer>();

        private Parsed(@NotNull Config config) {
            Object value;
            String key;
            for (Map.Entry<String, String> entry : config.effects.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value == null || key == null) continue;
                this.effects.put((class_5321<class_8056>)class_5321.method_29179((class_5321)class_7924.field_42082, (class_2960)new class_2960(key)), (class_5321<class_1291>)class_5321.method_29179((class_5321)class_7924.field_41208, (class_2960)new class_2960((String)value)));
            }
            for (Map.Entry<String, Object> entry : config.strengths.entrySet()) {
                key = entry.getKey();
                value = (Integer)entry.getValue();
                if (value == null || key == null) continue;
                this.strengths.put((class_5321<class_8054>)class_5321.method_29179((class_5321)class_7924.field_42083, (class_2960)new class_2960(key)), (Integer)value);
            }
        }

        @NotNull
        public Map<class_5321<class_8056>, class_5321<class_1291>> getEffects() {
            return this.effects;
        }

        @NotNull
        public Map<class_5321<class_8054>, Integer> getStrengths() {
            return this.strengths;
        }
    }
}

