/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.mojang.serialization.DynamicOps;
import dev.foxgirl.trimeffects.Config;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="trimeffects")
public final class TrimEffects {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    private static TrimEffects INSTANCE;
    private Config.Parsed config;

    public static TrimEffects getInstance() {
        return INSTANCE;
    }

    public TrimEffects() {
        INSTANCE = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
    }

    @NotNull
    public Config.Parsed getConfig() {
        return Objects.requireNonNull(this.config, "Expression 'config'");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        this.config = Config.read().parse();
    }

    @NotNull
    public static <T> ResourceKey<T> getKey(@NotNull Holder<T> entry) {
        return (ResourceKey)entry.m_203543_().orElseThrow();
    }

    @Nullable
    public static ArmorTrim getTrim(@NotNull RegistryAccess manager, @NotNull ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("Trim");
        if (nbt == null || !stack.m_204117_(ItemTags.f_265942_)) {
            return null;
        }
        return ArmorTrim.f_265985_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)manager), (Object)nbt).result().orElse(null);
    }

    public void handlePlayerTick(ServerPlayer player) {
        MobEffect effectType;
        List armor;
        RegistryAccess manager = player.m_9236_().m_9598_();
        ArmorTrim trim = TrimEffects.getTrim(manager, (ItemStack)(armor = (List)player.m_6168_()).get(0));
        if (trim == null) {
            return;
        }
        ResourceKey pattern = TrimEffects.getKey(trim.m_266429_());
        ResourceKey material = TrimEffects.getKey(trim.m_266210_());
        int size = armor.size();
        for (int i = 1; i < size; ++i) {
            ArmorTrim trimCurrent = TrimEffects.getTrim(manager, (ItemStack)armor.get(i));
            if (trimCurrent == null) {
                return;
            }
            if (pattern == TrimEffects.getKey(trimCurrent.m_266429_()) && material == TrimEffects.getKey(trimCurrent.m_266210_())) continue;
            return;
        }
        ResourceKey<MobEffect> effect = this.getConfig().getEffects().get(pattern);
        Integer strength = this.getConfig().getStrengths().get(material);
        if (effect != null && strength != null && strength > 0 && (effectType = (MobEffect)manager.m_175515_(Registries.f_256929_).m_6246_(effect)) != null) {
            player.m_147207_(new MobEffectInstance(effectType, 95, strength - 1), (Entity)player);
        }
    }
}

