/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.client.event.ClientSetup;
import cy.jdkdigital.trophymanager.common.block.TrophyBlock;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.init.ModEntities;
import cy.jdkdigital.trophymanager.init.ModItems;
import cy.jdkdigital.trophymanager.init.ModRecipeTypes;
import cy.jdkdigital.trophymanager.network.Networking;
import cy.jdkdigital.trophymanager.setup.ClientProxy;
import cy.jdkdigital.trophymanager.setup.IProxy;
import cy.jdkdigital.trophymanager.setup.ServerProxy;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="trophymanager")
public class TrophyManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "trophymanager";
    public static final IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public TrophyManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDeath);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::doCommonStuff);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, TrophyManagerConfig.SERVER_CONFIG);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(ClientSetup::init));
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        Networking.registerMessages();
    }

    private void onEntityDeath(LivingDeathEvent event) {
        Entity deadEntity = event.getEntity();
        Entity source = event.getSource().func_76346_g();
        if (((Boolean)TrophyManagerConfig.GENERAL.dropFromMobs.get()).booleanValue() && !(deadEntity instanceof PlayerEntity) && source instanceof PlayerEntity) {
            boolean willDropTrophy;
            World level = deadEntity.field_70170_p;
            Double chance = deadEntity.func_184222_aU() ? (Double)TrophyManagerConfig.GENERAL.dropChanceMobs.get() : (Double)TrophyManagerConfig.GENERAL.dropChanceBoss.get();
            boolean bl = willDropTrophy = chance >= level.field_73012_v.nextDouble();
            if (((Boolean)TrophyManagerConfig.GENERAL.useLootingEnchant.get()).booleanValue() && source instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)source;
                int lootingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)player.func_184614_ca());
                for (int i = 0; i < 1 + lootingLevel; ++i) {
                    willDropTrophy = willDropTrophy || chance >= level.field_73012_v.nextDouble();
                }
            }
            if (willDropTrophy) {
                CompoundNBT entityTag = new CompoundNBT();
                deadEntity.func_70039_c(entityTag);
                ItemStack trophy = TrophyBlock.createTrophy(deadEntity, entityTag);
                Block.func_180635_a((World)deadEntity.field_70170_p, (BlockPos)deadEntity.func_233580_cy_(), (ItemStack)trophy);
            }
        }
    }
}

