/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.network.Networking;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TrophyScreen
extends Screen {
    private static final int WIDTH = 150;
    private static final int HEIGHT = 150;
    private static final ResourceLocation GUI = new ResourceLocation("trophymanager", "textures/gui/trophy.png");
    private final TrophyBlockEntity trophy;

    protected TrophyScreen(BlockPos pos) {
        super((ITextComponent)new TranslationTextComponent("gui.trophy.screen"));
        World level = TrophyManager.proxy.getWorld();
        this.trophy = (TrophyBlockEntity)level.func_175625_s(pos);
    }

    protected void func_231160_c_() {
        int relX = (this.field_230708_k_ - 150) / 2;
        int relY = (this.field_230709_l_ - 150) / 2;
        this.func_230480_a_((Widget)new Button(relX + 10, relY + 10, 20, 20, (ITextComponent)new StringTextComponent("-"), button -> this.adjustScale(-1.0f)));
        this.func_230480_a_((Widget)new Button(relX + 120, relY + 10, 20, 20, (ITextComponent)new StringTextComponent("+"), button -> this.adjustScale(1.0f)));
        this.func_230480_a_((Widget)new Button(relX + 10, relY + 35, 20, 20, (ITextComponent)new StringTextComponent("-"), button -> this.adjustOffsetY(-1.0)));
        this.func_230480_a_((Widget)new Button(relX + 120, relY + 35, 20, 20, (ITextComponent)new StringTextComponent("+"), button -> this.adjustOffsetY(1.0)));
        this.func_230480_a_((Widget)new Button(relX + 10, relY + 60, 65, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> TrophyScreen.close()));
        this.func_230480_a_((Widget)new Button(relX + 75, relY + 60, 65, 20, (ITextComponent)new TranslationTextComponent("gui.ok"), button -> TrophyScreen.save(this)));
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        assert (this.field_230706_i_ != null);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI);
        int relX = (this.field_230708_k_ - 150) / 2;
        int relY = (this.field_230709_l_ - 150) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, 150, 150);
        TrophyScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("" + this.trophy.scale), (int)(relX + 75), (int)(relY + 15), (int)0xA0A0A0);
        TrophyScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("" + this.trophy.offsetY), (int)(relX + 75), (int)(relY + 40), (int)0xA0A0A0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void adjustScale(float d) {
        if (Screen.func_231173_s_()) {
            d *= 10.0f;
        }
        this.trophy.scale = (float)Math.min((double)((float)Math.round(this.trophy.scale * 10.0f + d) / 10.0f), (Double)TrophyManagerConfig.GENERAL.maxSize.get());
    }

    private void adjustOffsetY(double d) {
        if (Screen.func_231173_s_()) {
            d *= 10.0;
        }
        this.trophy.offsetY = (double)Math.round(this.trophy.offsetY * 10.0 + d) / 10.0;
    }

    public static void open(BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TrophyScreen(pos));
    }

    public static void save(TrophyScreen screen) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("OffsetY", screen.trophy.offsetY);
        tag.func_74776_a("Scale", screen.trophy.scale);
        Networking.sendToServer(new Networking.PacketUpdateTrophy(screen.trophy.func_174877_v(), tag));
        TrophyScreen.close();
    }

    public static void close() {
        Minecraft.func_71410_x().func_147108_a(null);
    }
}

