/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.render.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class TrophyBlockEntityRenderer
extends TileEntityRenderer<TrophyBlockEntity> {
    public TrophyBlockEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(@Nonnull TrophyBlockEntity trophyTileEntity, float v, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (trophyTileEntity.trophyType != null) {
            Entity entity;
            if (trophyTileEntity.trophyType.equals("item") && trophyTileEntity.item != null) {
                this.renderItem(trophyTileEntity, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
            } else if (trophyTileEntity.trophyType.equals("entity") && (entity = trophyTileEntity.getEntity()) != null) {
                this.renderEntity(trophyTileEntity, matrixStack, buffer, combinedLightIn);
            }
        }
        this.renderBase(trophyTileEntity, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderBase(TrophyBlockEntity trophyTileEntity, MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        Block baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(trophyTileEntity.baseBlock);
        if (baseBlock != null) {
            Minecraft.func_71410_x().func_175602_ab().renderBlock(baseBlock.func_176223_P(), matrixStack, buffer, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
        }
    }

    private void renderItem(TrophyBlockEntity trophyTileEntity, MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        double tick = (double)System.currentTimeMillis() / 800.0;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, trophyTileEntity.offsetY + 0.5 + Math.sin(tick / 25.0) / 15.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(tick * 40.0 % 360.0)));
        matrixStack.func_227862_a_(trophyTileEntity.scale, trophyTileEntity.scale, trophyTileEntity.scale);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(trophyTileEntity.item, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }

    private void renderEntity(TrophyBlockEntity trophyTileEntity, MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLightIn) {
        float angle = 0.0f;
        if (trophyTileEntity.func_145831_w() != null) {
            Direction facing = (Direction)trophyTileEntity.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D);
            if (facing == Direction.NORTH) {
                angle = 180.0f;
            } else if (facing == Direction.SOUTH) {
                angle = 0.0f;
            } else if (facing == Direction.EAST) {
                angle = 90.0f;
            } else if (facing == Direction.WEST) {
                angle = 270.0f;
            }
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, trophyTileEntity.offsetY, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        matrixStack.func_227862_a_(trophyTileEntity.scale, trophyTileEntity.scale, trophyTileEntity.scale);
        if (trophyTileEntity.entityTag.func_74779_i("entityType").equals("minecraft:ender_dragon")) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        EntityRendererManager entityRendererManager = Minecraft.func_71410_x().func_175598_ae();
        entityRendererManager.func_178633_a(false);
        Entity cachedEntity = trophyTileEntity.getEntity();
        entityRendererManager.func_229084_a_(cachedEntity, 0.0, 0.0, 0.0, Minecraft.func_71410_x().func_184121_ak(), 1.0f, matrixStack, buffer, combinedLightIn);
        TrophyBlockEntityRenderer.renderPassengers(cachedEntity, entityRendererManager, matrixStack, buffer, combinedLightIn);
        matrixStack.func_227865_b_();
    }

    private static void renderPassengers(Entity entity, EntityRendererManager entityRendererManager, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn) {
        if (entity.func_184207_aI()) {
            for (Entity rider : entity.func_184188_bt()) {
                entity.func_184232_k(rider);
                entityRendererManager.func_229084_a_(rider, rider.func_226277_ct_(), rider.func_226278_cu_(), rider.func_226281_cx_(), Minecraft.func_71410_x().func_184121_ak(), 1.0f, matrixStack, buffer, combinedLightIn);
                TrophyBlockEntityRenderer.renderPassengers(rider, entityRendererManager, matrixStack, buffer, combinedLightIn);
            }
        }
    }
}

