/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.block;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.init.ModTags;
import cy.jdkdigital.trophymanager.network.Networking;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TrophyBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SLAB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0);

    public TrophyBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.FALSE)).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH));
    }

    public boolean func_220074_n(@Nonnull BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{BlockStateProperties.field_208198_y}).func_206894_a(new Property[]{HorizontalBlock.field_185512_D});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SLAB;
    }

    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull PathType pathType) {
        return false;
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.func_201670_d() && tileEntity instanceof TrophyBlockEntity) {
            ((TrophyBlockEntity)tileEntity).loadData(stack.func_196082_o());
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModBlockEntities.TROPHY.get()).func_200968_a();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)ModBlocks.TROPHY.get());
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TrophyBlockEntity) {
            try {
                CompoundNBT tag = tileEntity.func_189515_b(new CompoundNBT());
                stack.func_77982_d(tag.func_74775_l("TrophyData"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack;
    }

    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult traceResult) {
        TileEntity blockEntity;
        TileEntity blockEntity2;
        Block heldBlock;
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof BlockItem && (heldBlock = ((BlockItem)heldItem.func_77973_b()).func_179223_d()).func_203417_a(ModTags.TROPHY_BASE) && (blockEntity2 = world.func_175625_s(pos)) instanceof TrophyBlockEntity) {
            ((TrophyBlockEntity)blockEntity2).baseBlock = heldBlock.getRegistryName();
            return ActionResultType.SUCCESS;
        }
        if (!world.func_201670_d() && heldItem.func_77973_b() instanceof ArmorItem && (blockEntity = world.func_175625_s(pos)) instanceof TrophyBlockEntity) {
            return ((TrophyBlockEntity)blockEntity).equipArmor(heldItem);
        }
        if (!world.func_201670_d() && (heldItem.func_77973_b() instanceof ToolItem || heldItem.func_77973_b() instanceof ShieldItem) && (blockEntity = world.func_175625_s(pos)) instanceof TrophyBlockEntity) {
            return ((TrophyBlockEntity)blockEntity).equipTool(heldItem);
        }
        if (!world.func_201670_d() && player instanceof ServerPlayerEntity && (((Boolean)TrophyManagerConfig.GENERAL.allowNonOpEdit.get()).booleanValue() || player.func_211513_k(2)) && (blockEntity = world.func_175625_s(pos)) instanceof TrophyBlockEntity) {
            Networking.sendToClient(new Networking.PacketOpenGui(blockEntity.func_174877_v()), (ServerPlayerEntity)player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos otherPos, boolean condition) {
        TileEntity te;
        if (!level.field_72995_K && level.func_175640_z(pos) && (te = level.func_175625_s(pos)) instanceof TrophyBlockEntity && ((TrophyBlockEntity)te).trophyType.equals("entity")) {
            String entity;
            switch (entity = ((TrophyBlockEntity)te).entityTag.func_74779_i("entityType")) {
                case "minecraft:creeper": {
                    level.func_184133_a(null, pos, SoundEvents.field_187572_ar, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:iron_golem": {
                    level.func_184133_a(null, pos, SoundEvents.field_226142_fM_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:snow_golem": {
                    level.func_184133_a(null, pos, SoundEvents.field_187805_fE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:ender_dragon": {
                    level.func_184133_a(null, pos, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:bee": {
                    level.func_184133_a(null, pos, SoundEvents.field_226134_ai_, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:hoglin": {
                    level.func_184133_a(null, pos, SoundEvents.field_232713_fC_, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:zoglin": {
                    level.func_184133_a(null, pos, SoundEvents.field_232851_rv_, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:slime": {
                    level.func_184133_a(null, pos, SoundEvents.field_187886_fs, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:turtle": {
                    level.func_184133_a(null, pos, SoundEvents.field_203277_iv, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:llama": 
                case "minecraft:trader_llama": {
                    if (level.field_73012_v.nextInt(10) == 1) {
                        level.func_184133_a(null, pos, SoundEvents.field_191255_dF, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        break;
                    }
                }
                case "minecraft:tropical_fish": 
                case "minecraft:pufferfish": {
                    level.func_184133_a(null, pos, SoundEvents.field_187547_bF, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:ghast": {
                    if (level.field_73012_v.nextInt(10) == 1) {
                        level.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        break;
                    }
                    level.func_184133_a(null, pos, SoundEvents.field_187559_bL, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                default: {
                    SoundEvent sound;
                    Entity e = ((TrophyBlockEntity)te).getEntity();
                    if (!(e instanceof MobEntity) || (sound = ((MobEntity)e).func_184639_G()) == null) break;
                    level.func_184133_a(null, pos, sound, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    public void func_149666_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        String[] entities;
        for (String entityId : entities = new String[]{"bat", "bee", "blaze", "cat", "cave_spider", "chicken", "cow", "creeper", "dolphin", "donkey", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "fox", "ghast", "guardian", "hoglin", "horse", "husk", "illusioner", "iron_golem", "llama", "magma_cube", "mule", "mooshroom", "ocelot", "panda", "parrot", "phantom", "pig", "piglin", "piglin_brute", "pillager", "polar_bear", "pufferfish", "rabbit", "ravager", "sheep", "shulker", "silverfish", "skeleton", "skeleton_horse", "slime", "snow_golem", "spider", "squid", "stray", "strider", "trader_llama", "tropical_fish", "turtle", "vex", "villager", "vindicator", "wandering_trader", "witch", "wither", "wither_skeleton", "wolf", "zoglin", "zombie", "zombie_horse", "zombie_villager", "zombified_piglin"}) {
            items.add((Object)TrophyBlock.createTrophy("minecraft:" + entityId, new CompoundNBT(), TrophyBlock.idToName("minecraft:" + entityId)));
        }
    }

    public static ItemStack createTrophy(Entity entity, CompoundNBT tag) {
        ITextComponent name = entity.func_145748_c_();
        return TrophyBlock.createTrophy(entity.func_70022_Q(), tag, name.getString());
    }

    public static ItemStack createTrophy(String entityId, CompoundNBT tag, String name) {
        String identifier = entityId;
        CompoundNBT entityTag = new CompoundNBT();
        for (String s : (List)TrophyManagerConfig.GENERAL.nbtMap.get()) {
            String[] nbtInfo = s.split(":");
            if (nbtInfo.length != 3 || !(nbtInfo[0] + ":" + nbtInfo[1]).equals(entityId) || !tag.func_74764_b(nbtInfo[2]) || tag.func_74781_a(nbtInfo[2]) == null) continue;
            entityTag.func_218657_a(nbtInfo[2], tag.func_74781_a(nbtInfo[2]));
            identifier = identifier + ":" + tag.func_74781_a(nbtInfo[2]).func_150285_a_();
        }
        CompoundNBT trophyTag = new CompoundNBT();
        ItemStack trophy = new ItemStack((IItemProvider)ModBlocks.TROPHY.get());
        trophyTag.func_74778_a("TrophyType", "entity");
        entityTag.func_74778_a("entityType", entityId);
        switch (entityId) {
            case "minecraft:ender_dragon": {
                trophyTag.func_74776_a("Scale", 0.1f);
                trophyTag.func_74780_a("OffsetY", 0.8);
                break;
            }
            case "minecraft:ghast": {
                trophyTag.func_74776_a("Scale", 0.4f);
                trophyTag.func_74780_a("OffsetY", 1.4);
                break;
            }
            case "minecraft:bee": 
            case "minecraft:vex": 
            case "minecraft:phantom": {
                trophyTag.func_74780_a("OffsetY", 0.8);
                break;
            }
            case "minecraft:pufferfish": {
                entityTag.func_74768_a("PuffState", 1);
                break;
            }
            case "minecraft:shulker": {
                entityTag.func_74768_a("Color", 2);
                entityTag.func_74768_a("Peek", 30);
            }
        }
        trophyTag.func_218657_a("TrophyEntity", (INBT)entityTag);
        trophyTag.func_74778_a("Name", name + " trophy");
        trophyTag.func_74778_a("identifier", identifier);
        trophy.func_77982_d(trophyTag);
        return trophy;
    }

    private static String idToName(String id) {
        int start = id.indexOf(":") + 1;
        return id.substring(start, start + 1).toUpperCase() + id.substring(start + 1).replace("_", " ");
    }
}

