/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.item;

import cy.jdkdigital.trophymanager.common.entity.TrophyMinecartEntity;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.MinecartItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TrophyMinecartItem
extends MinecartItem {
    public TrophyMinecartItem(Item.Properties properties) {
        super(AbstractMinecartEntity.Type.RIDEABLE, properties);
    }

    @Nonnull
    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("Name")) {
            return new TranslationTextComponent(tag.func_74779_i("Name"));
        }
        return super.func_200295_i(stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (!blockstate.func_235714_a_((ITag)BlockTags.field_203437_y)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemstack = context.func_195996_i();
        if (!world.field_72995_K) {
            RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.func_208092_c()) {
                d0 = 0.5;
            }
            TrophyMinecartEntity minecartEntity = TrophyMinecartItem.createMinecart(world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.0625 + d0, (double)blockpos.func_177952_p() + 0.5);
            if (itemstack.func_82837_s()) {
                minecartEntity.func_200203_b(itemstack.func_200301_q());
            }
            ItemStack trophy = new ItemStack((IItemProvider)ModBlocks.TROPHY.get());
            trophy.func_77982_d(itemstack.func_77978_p());
            minecartEntity.setTrophy(trophy.serializeNBT());
            world.func_217376_c((Entity)minecartEntity);
        }
        itemstack.func_190918_g(1);
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public static TrophyMinecartEntity createMinecart(World level, double xPos, double yPos, double zPos) {
        return new TrophyMinecartEntity(level, xPos, yPos, zPos);
    }
}

