/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.tileentity;

import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TrophyBlockEntity
extends TileEntity {
    private static final Map<Integer, Entity> cachedEntities = new HashMap<Integer, Entity>();
    public String trophyType;
    public ItemStack item = null;
    public CompoundNBT entityTag = null;
    public double offsetY;
    public float scale;
    public ResourceLocation baseBlock;
    private String name;
    private String identifier = "";

    public TrophyBlockEntity() {
        super((TileEntityType)ModBlockEntities.TROPHY.get());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos pos = this.func_174877_v();
        return new AxisAlignedBB(pos, pos.func_177982_a(1, 2, 1));
    }

    public void func_230337_a_(@Nonnull BlockState blockState, @Nonnull CompoundNBT tag) {
        super.func_230337_a_(blockState, tag);
        this.loadData(tag.func_74775_l("TrophyData"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        super.func_189515_b(tag);
        CompoundNBT trophyTag = new CompoundNBT();
        if (this.trophyType != null) {
            trophyTag.func_74778_a("TrophyType", this.trophyType);
            if (!this.identifier.isEmpty()) {
                trophyTag.func_74778_a("identifier", this.identifier);
            }
            if (this.item != null) {
                trophyTag.func_218657_a("TrophyItem", (INBT)this.item.func_77955_b(new CompoundNBT()));
            }
            if (this.entityTag != null) {
                trophyTag.func_218657_a("TrophyEntity", (INBT)this.entityTag);
            }
            trophyTag.func_74780_a("OffsetY", this.offsetY);
            trophyTag.func_74776_a("Scale", this.scale);
            trophyTag.func_74778_a("BaseBlock", this.baseBlock.toString());
            if (this.name != null) {
                trophyTag.func_74778_a("Name", this.name);
            }
            tag.func_218657_a("TrophyData", (INBT)trophyTag);
        }
        return tag;
    }

    public void loadData(CompoundNBT tag) {
        TrophyBlockEntity.populateDefaultData(tag);
        this.trophyType = tag.func_74779_i("TrophyType");
        if (tag.func_74764_b("identifier")) {
            this.identifier = tag.func_74779_i("identifier");
        }
        if (tag.func_74764_b("TrophyItem")) {
            CompoundNBT itemTag = tag.func_74775_l("TrophyItem");
            if (!itemTag.func_74764_b("Count")) {
                itemTag.func_74780_a("Count", 1.0);
            }
            this.item = ItemStack.func_199557_a((CompoundNBT)itemTag);
        }
        if (tag.func_74764_b("TrophyEntity")) {
            this.entityTag = tag.func_74775_l("TrophyEntity");
            if (this.identifier.isEmpty()) {
                this.identifier = this.entityTag.func_74779_i("entityType");
            }
        }
        this.scale = tag.func_74760_g("Scale");
        this.offsetY = tag.func_74769_h("OffsetY");
        this.baseBlock = new ResourceLocation(tag.func_74779_i("BaseBlock"));
        if (tag.func_74764_b("Name")) {
            this.name = tag.func_74779_i("Name");
        }
    }

    public static void populateDefaultData(CompoundNBT tag) {
        if (!tag.func_74764_b("TrophyType")) {
            tag.func_74778_a("TrophyType", "item");
        }
        if (!tag.func_74764_b("TrophyItem") && tag.func_74779_i("TrophyType").equals("item")) {
            tag.func_218657_a("TrophyItem", (INBT)new ItemStack((IItemProvider)Items.field_196100_at).serializeNBT());
        }
        if (!tag.func_74764_b("Scale")) {
            tag.func_74776_a("Scale", 0.5f);
        }
        if (!tag.func_74764_b("OffsetY")) {
            tag.func_74780_a("OffsetY", ((Double)TrophyManagerConfig.GENERAL.defaultYOffset.get()).doubleValue());
        }
        if (!tag.func_74764_b("BaseBlock")) {
            tag.func_74778_a("BaseBlock", (String)TrophyManagerConfig.GENERAL.defaultBaseBlock.get());
        }
    }

    public Entity getEntity() {
        return TrophyBlockEntity.getCachedEntity(this.entityTag);
    }

    public static Entity getCachedEntity(CompoundNBT tag) {
        int key = tag.hashCode();
        if (!cachedEntities.containsKey(key)) {
            Entity cachedEntity = TrophyBlockEntity.createEntity(TrophyManager.proxy.getWorld(), tag);
            if (cachedEntity instanceof IAngerable && tag.func_74764_b("AngerTime")) {
                ((IAngerable)cachedEntity).func_230260_a__(tag.func_74762_e("AngerTime"));
            } else if (cachedEntity instanceof ShulkerEntity && tag.func_74764_b("Peek")) {
                ((ShulkerEntity)cachedEntity).func_184691_a(tag.func_74762_e("Peek"));
            }
            try {
                TrophyBlockEntity.addPassengers(cachedEntity, tag);
            }
            catch (Exception exception) {
                // empty catch block
            }
            cachedEntities.put(key, cachedEntity);
        }
        return cachedEntities.getOrDefault(key, null);
    }

    private static Entity createEntity(World world, CompoundNBT tag) {
        return TrophyBlockEntity.createEntity(world, tag.func_74779_i("entityType"), tag);
    }

    private static Entity createEntity(World world, String entityType, CompoundNBT tag) {
        EntityType type = EntityType.func_220327_a((String)entityType).orElse(null);
        if (type != null) {
            try {
                Entity loadedEntity = type.func_200721_a(world);
                if (loadedEntity != null) {
                    loadedEntity.func_70020_e(tag);
                    return loadedEntity;
                }
            }
            catch (Exception e) {
                TrophyManager.LOGGER.warn("Unable to load trophy entity " + entityType + ". Please report it to the mod author at https://github.com/JDKDigital/trophymanager/issues");
                TrophyManager.LOGGER.warn("Error: " + e.getMessage());
                TrophyManager.LOGGER.warn("NBT: " + tag);
                return null;
            }
        }
        return null;
    }

    private static void addPassengers(Entity vehicle, CompoundNBT entityTag) {
        if (entityTag.func_74764_b("Passengers")) {
            ListNBT passengers = entityTag.func_150295_c("Passengers", 10);
            for (int l = 0; l < passengers.size(); ++l) {
                CompoundNBT riderTag = passengers.func_150305_b(l);
                Entity rider = TrophyBlockEntity.createEntity(TrophyManager.proxy.getWorld(), riderTag.func_74779_i("id"), riderTag);
                if (rider != null) {
                    rider.func_184220_m(vehicle);
                }
                TrophyBlockEntity.addPassengers(rider, riderTag);
            }
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    public ActionResultType equipArmor(ItemStack heldItem) {
        if (!this.canEquip(this.getEntity())) {
            return ActionResultType.PASS;
        }
        ListNBT armorList = this.entityTag.func_74764_b("ArmorItems") ? this.entityTag.func_150295_c("ArmorItems", 10) : new ListNBT();
        NonNullList armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        for (int l = 0; l < armorItems.size(); ++l) {
            armorItems.set(l, (Object)ItemStack.func_199557_a((CompoundNBT)armorList.func_150305_b(l)));
        }
        Item armorItem = heldItem.func_77973_b();
        if (armorItem instanceof ArmorItem) {
            int slot = ((ArmorItem)armorItem).func_185083_B_().func_188454_b();
            if (((ItemStack)armorItems.get(slot)).func_77973_b().equals(armorItem)) {
                armorItems.set(slot, (Object)ItemStack.field_190927_a);
            } else {
                armorItems.set(slot, (Object)heldItem);
            }
        }
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : armorItems) {
            CompoundNBT compoundnbt = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        this.entityTag.func_82580_o("ArmorItems");
        if (!listnbt.isEmpty()) {
            this.entityTag.func_218657_a("ArmorItems", (INBT)listnbt);
        }
        if (this.field_145850_b instanceof ServerWorld) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResultType equipTool(ItemStack heldItem) {
        int slot;
        if (!this.canEquip(this.getEntity())) {
            return ActionResultType.PASS;
        }
        ListNBT handList = this.entityTag.func_74764_b("HandItems") ? this.entityTag.func_150295_c("HandItems", 10) : new ListNBT();
        NonNullList handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        for (int l = 0; l < handItems.size(); ++l) {
            handItems.set(l, (Object)ItemStack.func_199557_a((CompoundNBT)handList.func_150305_b(l)));
        }
        int n = slot = heldItem.func_77973_b() instanceof ShieldItem ? 1 : 0;
        if (((ItemStack)handItems.get(slot)).func_77973_b().equals(heldItem.func_77973_b())) {
            handItems.set(slot, (Object)ItemStack.field_190927_a);
        } else {
            handItems.set(slot, (Object)heldItem);
        }
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : handItems) {
            CompoundNBT compoundnbt = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        this.entityTag.func_82580_o("HandItems");
        if (!listnbt.isEmpty()) {
            this.entityTag.func_218657_a("HandItems", (INBT)listnbt);
        }
        if (this.field_145850_b instanceof ServerWorld) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
        return ActionResultType.CONSUME;
    }

    public boolean canEquip(Entity cachedEntity) {
        return cachedEntity instanceof MobEntity || cachedEntity instanceof ArmorStandEntity;
    }
}

