/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.network;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.client.gui.TrophyScreen;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class Networking {
    private static SimpleChannel INSTANCE;
    private static int ID;

    private static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trophymanager", "trophy"), () -> "1.0", s -> true, s -> true);
        INSTANCE.messageBuilder(PacketOpenGui.class, Networking.nextID()).encoder((packetOpenGui, packetBuffer) -> packetBuffer.func_179255_a(((PacketOpenGui)packetOpenGui).pos)).decoder(buf -> new PacketOpenGui(buf.func_179259_c())).consumer(PacketOpenGui::handle).add();
        INSTANCE.messageBuilder(PacketUpdateTrophy.class, Networking.nextID()).encoder((packetUpdateTrophy, packetBuffer) -> {
            packetBuffer.func_179255_a(((PacketUpdateTrophy)packetUpdateTrophy).pos);
            packetBuffer.func_150786_a(((PacketUpdateTrophy)packetUpdateTrophy).tag);
        }).decoder(buf -> new PacketUpdateTrophy(buf.func_179259_c(), buf.func_244273_m())).consumer(PacketUpdateTrophy::handle).add();
    }

    public static void sendToClient(Object packet, ServerPlayerEntity player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }

    static {
        ID = 0;
    }

    public static class PacketOpenGui {
        private BlockPos pos;

        public PacketOpenGui(BlockPos pos) {
            this.pos = pos;
        }

        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> TrophyScreen.open(this.pos));
            return true;
        }
    }

    public static class PacketUpdateTrophy {
        private final BlockPos pos;
        private final CompoundNBT tag;

        public PacketUpdateTrophy(BlockPos pos, CompoundNBT tag) {
            this.pos = pos;
            this.tag = tag;
        }

        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerWorld level;
                TileEntity te;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (te = (level = player.func_71121_q()).func_175625_s(this.pos)) instanceof TrophyBlockEntity) {
                    ((TrophyBlockEntity)te).offsetY = this.tag.func_74769_h("OffsetY");
                    ((TrophyBlockEntity)te).scale = (float)Math.min((double)this.tag.func_74760_g("Scale"), (Double)TrophyManagerConfig.GENERAL.maxSize.get());
                    te.func_70296_d();
                }
            });
            return true;
        }
    }
}

