/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.trophymanager.common.item.TrophyItem;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.init.ModItems;
import cy.jdkdigital.trophymanager.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TrophyMinecartRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;

    public TrophyMinecartRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() != 2) {
            return false;
        }
        boolean hasMinecart = false;
        boolean hasTrophy = false;
        for (ItemStack itemstack : stacks) {
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b().equals(Items.field_151143_au)) {
                if (hasMinecart) {
                    return false;
                }
                hasMinecart = true;
            }
            if (!itemstack.func_77973_b().equals(((Block)ModBlocks.TROPHY.get()).func_199767_j())) continue;
            if (hasTrophy) {
                return false;
            }
            hasTrophy = true;
        }
        return hasMinecart && hasTrophy;
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() == 2) {
            ItemStack outStack = new ItemStack((IItemProvider)ModItems.TROPHY_MINECART.get());
            for (ItemStack itemstack : stacks) {
                if (!(itemstack.func_77973_b() instanceof TrophyItem)) continue;
                outStack.func_77982_d(itemstack.func_77978_p());
            }
            return outStack;
        }
        return ItemStack.field_190927_a;
    }

    private List<ItemStack> getItemsInInventory(CraftingInventory inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.TROPHY_MINECART.get());
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.func_77571_b()}));
        return list;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.TROPHY_MINECART.get();
    }

    public static class Serializer<T extends TrophyMinecartRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            return this.factory.create(id);
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
        }

        public static interface IRecipeFactory<T extends TrophyMinecartRecipe> {
            public T create(ResourceLocation var1);
        }
    }
}

