/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.network.Networking;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TrophyScreen
extends Screen {
    private static final int WIDTH = 150;
    private static final int HEIGHT = 150;
    private static final ResourceLocation GUI = new ResourceLocation("trophymanager", "textures/gui/trophy.png");
    private final TrophyBlockEntity trophy;

    protected TrophyScreen(BlockPos pos) {
        super((Component)new TranslatableComponent("gui.trophy.screen"));
        Level level = TrophyManager.proxy.getWorld();
        this.trophy = (TrophyBlockEntity)level.m_7702_(pos);
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 150) / 2;
        int relY = (this.f_96544_ - 150) / 2;
        this.m_142416_((GuiEventListener)new Button(relX + 10, relY + 10, 20, 20, (Component)new TextComponent("-"), button -> this.adjustScale(-1.0f)));
        this.m_142416_((GuiEventListener)new Button(relX + 120, relY + 10, 20, 20, (Component)new TextComponent("+"), button -> this.adjustScale(1.0f)));
        this.m_142416_((GuiEventListener)new Button(relX + 10, relY + 35, 20, 20, (Component)new TextComponent("-"), button -> this.adjustOffsetY(-1.0)));
        this.m_142416_((GuiEventListener)new Button(relX + 120, relY + 35, 20, 20, (Component)new TextComponent("+"), button -> this.adjustOffsetY(1.0)));
        this.m_142416_((GuiEventListener)new Button(relX + 10, relY + 60, 65, 20, (Component)new TranslatableComponent("gui.cancel"), button -> TrophyScreen.close()));
        this.m_142416_((GuiEventListener)new Button(relX + 76, relY + 60, 65, 20, (Component)new TranslatableComponent("gui.ok"), button -> TrophyScreen.save(this)));
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        int relX = (this.f_96543_ - 150) / 2;
        int relY = (this.f_96544_ - 150) / 2;
        this.m_93228_(matrixStack, relX, relY, 0, 0, 150, 150);
        TrophyScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)("" + this.trophy.scale), (int)(relX + 75), (int)(relY + 15), (int)0xA0A0A0);
        TrophyScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)("" + this.trophy.offsetY), (int)(relX + 75), (int)(relY + 40), (int)0xA0A0A0);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    private void adjustScale(float d) {
        if (Screen.m_96638_()) {
            d *= 10.0f;
        }
        this.trophy.scale = (float)Math.round(this.trophy.scale * 10.0f + d) / 10.0f;
    }

    private void adjustOffsetY(double d) {
        if (Screen.m_96638_()) {
            d *= 10.0;
        }
        this.trophy.offsetY = (double)Math.round(this.trophy.offsetY * 10.0 + d) / 10.0;
    }

    public static void open(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new TrophyScreen(pos));
    }

    public static void save(TrophyScreen screen) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("OffsetY", screen.trophy.offsetY);
        tag.m_128350_("Scale", screen.trophy.scale);
        Networking.sendToServer(new Networking.PacketUpdateTrophy(screen.trophy.m_58899_(), tag));
        TrophyScreen.close();
    }

    public static void close() {
        Minecraft.m_91087_().m_91152_(null);
    }
}

