/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.tileentity;

import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TrophyBlockEntity
extends BlockEntity {
    private static final Map<Integer, Entity> cachedEntities = new HashMap<Integer, Entity>();
    public String trophyType;
    public ItemStack item = null;
    public CompoundTag entity = null;
    public double offsetY;
    public float rotX;
    public float scale;
    public ResourceLocation baseBlock;
    private String name;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TROPHY.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos, pos.m_142082_(1, 2, 1));
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.loadData(tag.m_128469_("TrophyData"));
    }

    @Nonnull
    public CompoundTag m_6945_(@Nonnull CompoundTag tag) {
        super.m_6945_(tag);
        CompoundTag trophyTag = new CompoundTag();
        trophyTag.m_128359_("TrophyType", this.trophyType);
        if (this.item != null) {
            trophyTag.m_128365_("TrophyItem", (Tag)this.item.m_41739_(new CompoundTag()));
        }
        if (this.entity != null) {
            trophyTag.m_128365_("TrophyEntity", (Tag)this.entity);
        }
        trophyTag.m_128347_("OffsetY", this.offsetY);
        trophyTag.m_128350_("RotX", this.rotX);
        trophyTag.m_128350_("Scale", this.scale);
        trophyTag.m_128359_("BaseBlock", this.baseBlock.toString());
        if (this.name != null) {
            trophyTag.m_128359_("Name", this.name);
        }
        tag.m_128365_("TrophyData", (Tag)trophyTag);
        return tag;
    }

    public void loadData(CompoundTag tag) {
        String string = this.trophyType = tag.m_128441_("TrophyType") ? tag.m_128461_("TrophyType") : "item";
        if (tag.m_128441_("TrophyItem")) {
            CompoundTag itemTag = tag.m_128469_("TrophyItem");
            if (!itemTag.m_128441_("Count")) {
                itemTag.m_128347_("Count", 1.0);
            }
            this.item = ItemStack.m_41712_((CompoundTag)itemTag);
        } else if (this.trophyType.equals("item")) {
            this.item = new ItemStack((ItemLike)Items.f_42437_);
        }
        if (tag.m_128441_("TrophyEntity")) {
            this.entity = tag.m_128469_("TrophyEntity");
        }
        this.scale = tag.m_128441_("Scale") ? tag.m_128457_("Scale") : 0.5f;
        this.rotX = tag.m_128441_("RotX") ? tag.m_128457_("RotX") : 0.0f;
        this.offsetY = tag.m_128441_("OffsetY") ? tag.m_128459_("OffsetY") : 0.5;
        this.baseBlock = tag.m_128441_("BaseBlock") ? new ResourceLocation(tag.m_128461_("BaseBlock")) : new ResourceLocation("smooth_stone_slab");
        if (tag.m_128441_("Name")) {
            this.name = tag.m_128461_("Name");
        }
    }

    public Entity getCachedEntity() {
        int key = this.entity.hashCode();
        if (!cachedEntities.containsKey(key)) {
            Entity cachedEntity = TrophyBlockEntity.createEntity(TrophyManager.proxy.getWorld(), this.entity);
            if (cachedEntity != null) {
                if (cachedEntity instanceof NeutralMob && this.entity.m_128441_("AngerTime")) {
                    ((NeutralMob)cachedEntity).m_7870_(this.entity.m_128451_("AngerTime"));
                } else if (cachedEntity instanceof Shulker && this.entity.m_128441_("Peek")) {
                    ((Shulker)cachedEntity).m_33418_(this.entity.m_128451_("Peek"));
                }
                try {
                    TrophyBlockEntity.addPassengers(cachedEntity, this.entity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cachedEntities.put(key, cachedEntity);
        }
        return cachedEntities.getOrDefault(key, null);
    }

    private static Entity createEntity(Level world, CompoundTag tag) {
        return TrophyBlockEntity.createEntity(world, tag.m_128461_("entityType"), tag);
    }

    private static Entity createEntity(Level world, String entityType, CompoundTag tag) {
        EntityType type = EntityType.m_20632_((String)entityType).orElse(null);
        if (type != null) {
            try {
                Entity loadedEntity = type.m_20615_(world);
                if (loadedEntity != null) {
                    loadedEntity.m_20258_(tag);
                    return loadedEntity;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static void addPassengers(Entity vehicle, CompoundTag entityTag) {
        if (entityTag.m_128441_("Passengers")) {
            ListTag passengers = entityTag.m_128437_("Passengers", 10);
            for (int l = 0; l < passengers.size(); ++l) {
                CompoundTag riderTag = passengers.m_128728_(l);
                Entity rider = TrophyBlockEntity.createEntity(TrophyManager.proxy.getWorld(), riderTag.m_128461_("id"), riderTag);
                if (rider == null) continue;
                rider.m_20329_(vehicle);
                TrophyBlockEntity.addPassengers(rider, riderTag);
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), -1, this.m_5995_());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeNBT(tag);
    }
}

