/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.block;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.init.ModTags;
import cy.jdkdigital.trophymanager.network.Networking;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrophyBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SLAB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0);

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.FALSE)).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{BlockStateProperties.f_61362_}).m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SLAB;
    }

    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull PathComputationType pathType) {
        return false;
    }

    public void m_6402_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!level.m_5776_() && tileEntity instanceof TrophyBlockEntity) {
            CompoundTag tag = stack.m_41784_();
            ((TrophyBlockEntity)tileEntity).loadData(tag);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.TROPHY.get());
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof TrophyBlockEntity) {
            TrophyBlockEntity trophyTile = (TrophyBlockEntity)tileEntity;
            try {
                CompoundTag tag = tileEntity.m_187482_();
                stack.m_41751_(tag.m_128469_("TrophyData"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack;
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult traceResult) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        Block heldBlock;
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof BlockItem && ModTags.TROPHY_BASE.m_8110_((Object)(heldBlock = ((BlockItem)heldItem.m_41720_()).m_40614_())) && (blockEntity2 = world.m_7702_(pos)) instanceof TrophyBlockEntity) {
            ((TrophyBlockEntity)blockEntity2).baseBlock = heldBlock.getRegistryName();
            return InteractionResult.SUCCESS;
        }
        if (!world.m_5776_() && heldItem.m_41720_() instanceof ArmorItem && (blockEntity = world.m_7702_(pos)) instanceof TrophyBlockEntity) {
            return ((TrophyBlockEntity)blockEntity).equipArmor(heldItem);
        }
        if (!world.m_5776_() && (heldItem.m_41720_() instanceof TieredItem || heldItem.m_41720_() instanceof ShieldItem) && (blockEntity = world.m_7702_(pos)) instanceof TrophyBlockEntity) {
            return ((TrophyBlockEntity)blockEntity).equipTool(heldItem);
        }
        if (!world.m_5776_() && player instanceof ServerPlayer && (((Boolean)TrophyManagerConfig.GENERAL.allowNonOpEdit.get()).booleanValue() || player.m_20310_(2)) && (blockEntity = world.m_7702_(pos)) instanceof TrophyBlockEntity) {
            Networking.sendToClient(new Networking.PacketOpenGui(blockEntity.m_58899_()), (ServerPlayer)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean condition) {
        BlockEntity te;
        if (!level.f_46443_ && level.m_46753_(pos) && (te = level.m_7702_(pos)) instanceof TrophyBlockEntity && ((TrophyBlockEntity)te).trophyType.equals("entity")) {
            String entity;
            switch (entity = ((TrophyBlockEntity)te).entity.m_128461_("entityType")) {
                case "minecraft:creeper": {
                    level.m_5594_(null, pos, SoundEvents.f_11837_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:iron_golem": {
                    level.m_5594_(null, pos, SoundEvents.f_12058_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:snow_golem": {
                    level.m_5594_(null, pos, SoundEvents.f_12479_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:ender_dragon": {
                    level.m_5594_(null, pos, SoundEvents.f_11894_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:bee": {
                    level.m_5594_(null, pos, SoundEvents.f_11698_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:hoglin": {
                    level.m_5594_(null, pos, SoundEvents.f_11957_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:zoglin": {
                    level.m_5594_(null, pos, SoundEvents.f_12593_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:slime": {
                    level.m_5594_(null, pos, SoundEvents.f_12388_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:turtle": {
                    level.m_5594_(null, pos, SoundEvents.f_12530_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:llama": 
                case "minecraft:trader_llama": {
                    if (level.f_46441_.nextInt(10) == 1) {
                        level.m_5594_(null, pos, SoundEvents.f_12098_, SoundSource.HOSTILE, 1.0f, 1.0f);
                        break;
                    }
                }
                case "minecraft:tropical_fish": 
                case "minecraft:pufferfish": {
                    level.m_5594_(null, pos, SoundEvents.f_11917_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:ghast": {
                    if (level.f_46441_.nextInt(10) == 1) {
                        level.m_5594_(null, pos, SoundEvents.f_11923_, SoundSource.HOSTILE, 1.0f, 1.0f);
                        break;
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11924_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:goat": {
                    if (level.f_46441_.nextInt(2) == 1) {
                        level.m_5594_(null, pos, SoundEvents.f_144171_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        break;
                    }
                    level.m_5594_(null, pos, SoundEvents.f_144163_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                default: {
                    SoundEvent sound;
                    Entity e = ((TrophyBlockEntity)te).getCachedEntity();
                    if (!(e instanceof Mob) || (sound = ((Mob)e).m_7515_()) == null) break;
                    level.m_5594_(null, pos, sound, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        String[] entities;
        for (String entityId : entities = new String[]{"axolotl", "bat", "bee", "blaze", "cat", "cave_spider", "chicken", "cow", "creeper", "dolphin", "donkey", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "fox", "ghast", "glow_squid", "goat", "guardian", "hoglin", "horse", "husk", "illusioner", "iron_golem", "llama", "magma_cube", "mule", "mooshroom", "ocelot", "panda", "parrot", "phantom", "pig", "piglin", "piglin_brute", "pillager", "polar_bear", "pufferfish", "rabbit", "ravager", "sheep", "shulker", "silverfish", "skeleton", "skeleton_horse", "slime", "snow_golem", "spider", "squid", "stray", "strider", "trader_llama", "tropical_fish", "turtle", "vex", "villager", "vindicator", "wandering_trader", "witch", "wither", "wither_skeleton", "wolf", "zoglin", "zombie", "zombie_horse", "zombie_villager", "zombified_piglin"}) {
            items.add((Object)TrophyBlock.createTrophy("minecraft:" + entityId, new CompoundTag(), TrophyBlock.idToName("minecraft:" + entityId)));
        }
    }

    public static ItemStack createTrophy(Entity entity, CompoundTag tag) {
        Component name = entity.m_5446_();
        return TrophyBlock.createTrophy(entity.m_20078_(), tag, name.getString());
    }

    public static ItemStack createTrophy(String entityId, CompoundTag tag, String name) {
        CompoundTag entityTag = new CompoundTag();
        ((List)TrophyManagerConfig.GENERAL.nbtMap.get()).forEach(s -> {
            String[] nbtInfo = s.split(":");
            if (nbtInfo.length == 3 && (nbtInfo[0] + ":" + nbtInfo[1]).equals(entityId) && tag.m_128441_(nbtInfo[2]) && tag.m_128423_(nbtInfo[2]) != null) {
                entityTag.m_128365_(nbtInfo[2], tag.m_128423_(nbtInfo[2]));
            }
        });
        CompoundTag trophyTag = new CompoundTag();
        ItemStack trophy = new ItemStack((ItemLike)ModBlocks.TROPHY.get());
        trophyTag.m_128359_("TrophyType", "entity");
        entityTag.m_128359_("entityType", entityId);
        switch (entityId) {
            case "axolotl": {
                entityTag.m_128405_("Variant", 4);
                break;
            }
            case "ender_dragon": {
                trophyTag.m_128350_("Scale", 0.1f);
                trophyTag.m_128347_("OffsetY", 0.8);
                break;
            }
            case "ghast": {
                trophyTag.m_128350_("Scale", 0.4f);
                trophyTag.m_128347_("OffsetY", 1.4);
                break;
            }
            case "bee": 
            case "phantom": 
            case "vex": {
                trophyTag.m_128347_("OffsetY", 0.8);
                break;
            }
            case "pufferfish": {
                entityTag.m_128405_("PuffState", 1);
                break;
            }
            case "shulker": {
                entityTag.m_128405_("Color", 2);
                entityTag.m_128405_("Peek", 30);
                break;
            }
            case "glow_squid": {
                trophyTag.m_128350_("Scale", 0.4f);
                trophyTag.m_128350_("RotX", 70.0f);
                trophyTag.m_128347_("OffsetY", 0.7);
            }
        }
        trophyTag.m_128365_("TrophyEntity", (Tag)entityTag);
        trophyTag.m_128359_("Name", name + " trophy");
        trophy.m_41751_(trophyTag);
        return trophy;
    }

    private static String idToName(String id) {
        int start = id.indexOf(":") + 1;
        return id.substring(start, start + 1).toUpperCase() + id.substring(start + 1).replace("_", " ");
    }
}

