/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TrophyManagerConfig {
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final General GENERAL;

    static {
        GENERAL = new General(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue dropFromMobs;
        public final ForgeConfigSpec.BooleanValue applyLooting;
        public final ForgeConfigSpec.BooleanValue allowFakePlayer;
        public final ForgeConfigSpec.DoubleValue dropChanceBoss;
        public final ForgeConfigSpec.DoubleValue dropChanceMobs;
        public final ForgeConfigSpec.BooleanValue allowNonOpEdit;
        public final ForgeConfigSpec.DoubleValue maxSize;
        public final ForgeConfigSpec.ConfigValue<? extends String> defaultBaseBlock;
        public final ForgeConfigSpec.DoubleValue defaultYOffset;
        public final ForgeConfigSpec.ConfigValue<List<String>> nbtMap;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.dropFromMobs = builder.comment("Should trophies drop from mobs when killed by a player?").define("dropFromMobs", true);
            this.applyLooting = builder.comment("Looting enchant will increase drop change").define("applyLooting", true);
            this.allowFakePlayer = builder.comment("Allow fake players (machines) to get trophy drops").define("allowFakePlayer", true);
            this.dropChanceBoss = builder.comment("Drop chance for trophies when a boss entity is killed by a player.").defineInRange("dropChanceBoss", 0.2, 0.0, 1.0);
            this.dropChanceMobs = builder.comment("Drop chance for trophies when a normal entity is killed by a player.").defineInRange("dropChanceMobs", 0.02, 0.0, 1.0);
            this.allowNonOpEdit = builder.comment("Allow non opped players to change the settings for a trophy.").define("allowNonOpEdit", true);
            this.maxSize = builder.comment("Maximum size multiplier for a trophy.").defineInRange("maxSize", 20.0, 0.0, 2.147483647E9);
            this.defaultBaseBlock = builder.comment("Block to use for trophies dropped when killing a mob.").define("defaultBaseBlock", (Object)"minecraft:smooth_stone_slab");
            this.defaultYOffset = builder.comment("Default YOffset for trophies dropped when killing a mob. If defaultBaseBlock is a full block this should be 1.0, slabs 0.5 and carpets 0.1").defineInRange("defaultYOffset", 0.5, 0.0, 2.147483647E9);
            this.nbtMap = builder.comment("List of entities which has NBT data that needs to be saved with the trophy. Format: modid:entityid:tag.").define("nbtMap", (Object)new ArrayList<String>(){
                {
                    this.add("minecraft:axolotl:Variant");
                    this.add("minecraft:cat:CatType");
                    this.add("minecraft:llama:Variant");
                    this.add("minecraft:horse:Variant");
                    this.add("minecraft:fox:Variant");
                    this.add("minecraft:parrot:Variant");
                    this.add("minecraft:panda:MainGene");
                    this.add("minecraft:panda:HiddenGene");
                    this.add("minecraft:mooshroom:Type");
                    this.add("minecraft:villager:VillagerData");
                    this.add("productivebees:configurable_bee:type");
                    this.add("infernalexp:shroomloin:ShroomloinType");
                    this.add("infernalexp:basalt_giant:Size");
                }
            });
            builder.pop();
        }
    }
}

