/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.network;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.client.gui.TrophyScreen;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class Networking {
    private static SimpleChannel INSTANCE;
    private static int ID;

    private static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trophymanager", "trophy"), () -> "1.0", s -> true, s -> true);
        INSTANCE.messageBuilder(PacketOpenGui.class, Networking.nextID()).encoder((packetOpenGui, packetBuffer) -> packetBuffer.m_130064_(packetOpenGui.pos)).decoder(buf -> new PacketOpenGui(buf.m_130135_())).consumer(PacketOpenGui::handle).add();
        INSTANCE.messageBuilder(PacketUpdateTrophy.class, Networking.nextID()).encoder((packetUpdateTrophy, packetBuffer) -> {
            packetBuffer.m_130064_(packetUpdateTrophy.pos);
            packetBuffer.m_130079_(packetUpdateTrophy.tag);
        }).decoder(buf -> new PacketUpdateTrophy(buf.m_130135_(), buf.m_130261_())).consumer(PacketUpdateTrophy::handle).add();
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }

    static {
        ID = 0;
    }

    public static class PacketOpenGui {
        private BlockPos pos;

        public PacketOpenGui(BlockPos pos) {
            this.pos = pos;
        }

        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> TrophyScreen.open(this.pos));
            return true;
        }
    }

    public static class PacketUpdateTrophy {
        private final BlockPos pos;
        private final CompoundTag tag;

        public PacketUpdateTrophy(BlockPos pos, CompoundTag tag) {
            this.pos = pos;
            this.tag = tag;
        }

        public boolean handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerLevel level;
                BlockEntity blockEntity;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (blockEntity = (level = player.m_183503_()).m_7702_(this.pos)) instanceof TrophyBlockEntity) {
                    TrophyBlockEntity trophyBlockEntity = (TrophyBlockEntity)blockEntity;
                    trophyBlockEntity.offsetY = this.tag.m_128459_("OffsetY");
                    trophyBlockEntity.scale = (float)Math.min((double)this.tag.m_128457_("Scale"), (Double)TrophyManagerConfig.GENERAL.maxSize.get());
                    blockEntity.m_6596_();
                }
            });
            return true;
        }
    }
}

