/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull TrophyBlockEntity trophyTileEntity, float v, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (trophyTileEntity.trophyType != null) {
            Entity entity;
            if (trophyTileEntity.trophyType.equals("item") && trophyTileEntity.item != null) {
                this.renderItem(trophyTileEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
            } else if (trophyTileEntity.trophyType.equals("entity") && (entity = trophyTileEntity.getCachedEntity()) != null) {
                this.renderEntity(trophyTileEntity, poseStack, buffer, combinedLightIn);
            }
        }
        this.renderBase(trophyTileEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderBase(TrophyBlockEntity trophyTileEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Block baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(trophyTileEntity.baseBlock);
        if (baseBlock != null) {
            Minecraft.m_91087_().m_91289_().m_110912_(baseBlock.m_49966_(), poseStack, buffer, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderItem(TrophyBlockEntity trophyTileEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        double tick = (double)System.currentTimeMillis() / 800.0;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, trophyTileEntity.offsetY + 0.5 + Math.sin(tick / 25.0) / 15.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(tick * 40.0 % 360.0)));
        poseStack.m_85841_(trophyTileEntity.scale, trophyTileEntity.scale, trophyTileEntity.scale);
        Minecraft.m_91087_().m_91291_().m_174269_(trophyTileEntity.item, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, poseStack, buffer, 0);
        poseStack.m_85849_();
    }

    private void renderEntity(TrophyBlockEntity trophyTileEntity, PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn) {
        float angle = 0.0f;
        if (trophyTileEntity.m_58904_() != null) {
            Direction facing = (Direction)trophyTileEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (facing == Direction.NORTH) {
                angle = 180.0f;
            } else if (facing == Direction.SOUTH) {
                angle = 0.0f;
            } else if (facing == Direction.EAST) {
                angle = 90.0f;
            } else if (facing == Direction.WEST) {
                angle = 270.0f;
            }
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, trophyTileEntity.offsetY, 0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(trophyTileEntity.rotX));
        matrixStack.m_85841_(trophyTileEntity.scale, trophyTileEntity.scale, trophyTileEntity.scale);
        if (trophyTileEntity.entity.m_128461_("entityType").equals("minecraft:ender_dragon")) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        EntityRenderDispatcher entityRendererManager = Minecraft.m_91087_().m_91290_();
        entityRendererManager.m_114468_(false);
        Entity cachedEntity = trophyTileEntity.getCachedEntity();
        if (cachedEntity != null) {
            entityRendererManager.m_114384_(cachedEntity, 0.0, 0.0, 0.0, Minecraft.m_91087_().m_91296_(), 1.0f, matrixStack, buffer, combinedLightIn);
            TrophyBlockEntityRenderer.renderPassengers(cachedEntity, entityRendererManager, matrixStack, buffer, combinedLightIn);
        }
        matrixStack.m_85849_();
    }

    private static void renderPassengers(Entity entity, EntityRenderDispatcher entityRendererManager, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn) {
        if (entity.m_20160_()) {
            for (Entity rider : entity.m_20197_()) {
                entity.m_7332_(rider);
                entityRendererManager.m_114384_(rider, rider.m_20185_(), rider.m_20186_(), rider.m_20189_(), Minecraft.m_91087_().m_91296_(), 1.0f, matrixStack, buffer, combinedLightIn);
                TrophyBlockEntityRenderer.renderPassengers(rider, entityRendererManager, matrixStack, buffer, combinedLightIn);
            }
        }
    }
}

