/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager;

import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.client.render.block.TrophyBlockEntityRenderer;
import cy.jdkdigital.trophymanager.common.block.TrophyBlock;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.network.Networking;
import cy.jdkdigital.trophymanager.setup.ClientProxy;
import cy.jdkdigital.trophymanager.setup.IProxy;
import cy.jdkdigital.trophymanager.setup.ServerProxy;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="trophymanager")
public class TrophyManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "trophymanager";
    public static final IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public TrophyManager() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onAdvancementEarned);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::modComms);
        modEventBus.addListener(this::doCommonStuff);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlocks.ITEMS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TrophyManagerConfig.SERVER_CONFIG);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        Networking.registerMessages();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.TROPHY.get()), TrophyBlockEntityRenderer::new);
    }

    private void modComms(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("curios")) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onEntityDeath(LivingDeathEvent event) {
        boolean willDropTrophy;
        Player killedPlayer;
        LivingEntity deadEntity;
        block6: {
            int lootingLevel;
            Double chance;
            block7: {
                boolean willDropTrophy2;
                block4: {
                    int lootingLevel2;
                    Double chance2;
                    block5: {
                        Entity source;
                        block3: {
                            deadEntity = event.getEntity();
                            source = event.getSource().m_7639_();
                            if (!((Boolean)TrophyManagerConfig.GENERAL.dropFromMobs.get()).booleanValue() || deadEntity instanceof Player || !(source instanceof ServerPlayer)) break block3;
                            ServerPlayer player = (ServerPlayer)source;
                            if (source instanceof FakePlayer && !((Boolean)TrophyManagerConfig.GENERAL.allowFakePlayer.get()).booleanValue()) break block3;
                            chance2 = deadEntity.m_6072_() ? (Double)TrophyManagerConfig.GENERAL.dropChanceMobs.get() : (Double)TrophyManagerConfig.GENERAL.dropChanceBoss.get();
                            boolean bl = willDropTrophy2 = chance2 >= deadEntity.m_9236_().f_46441_.m_188500_();
                            if (!((Boolean)TrophyManagerConfig.GENERAL.applyLooting.get()).booleanValue()) break block4;
                            lootingLevel2 = player.m_21205_().getEnchantmentLevel(Enchantments.f_44982_);
                            break block5;
                        }
                        if ((Boolean)TrophyManagerConfig.GENERAL.dropFromPlayers.get() == false) return;
                        if (!(deadEntity instanceof Player)) return;
                        killedPlayer = (Player)deadEntity;
                        if (!(source instanceof ServerPlayer)) return;
                        ServerPlayer player = (ServerPlayer)source;
                        if (source instanceof FakePlayer) {
                            if ((Boolean)TrophyManagerConfig.GENERAL.allowFakePlayer.get() == false) return;
                        }
                        boolean bl = willDropTrophy = (chance = (Double)TrophyManagerConfig.GENERAL.dropChancePlayers.get()) >= deadEntity.m_9236_().f_46441_.m_188500_();
                        if (!((Boolean)TrophyManagerConfig.GENERAL.applyLooting.get()).booleanValue()) break block6;
                        lootingLevel = player.m_21205_().getEnchantmentLevel(Enchantments.f_44982_);
                        break block7;
                    }
                    for (int i = 0; i < 1 + lootingLevel2; ++i) {
                        willDropTrophy2 = willDropTrophy2 || chance2 >= deadEntity.m_9236_().f_46441_.m_188500_();
                    }
                }
                if (!willDropTrophy2) return;
                CompoundTag entityTag = new CompoundTag();
                deadEntity.m_20240_(entityTag);
                ItemStack trophy = TrophyBlock.createTrophy((Entity)deadEntity, entityTag);
                Block.m_49840_((Level)deadEntity.m_9236_(), (BlockPos)deadEntity.m_20183_(), (ItemStack)trophy);
                return;
            }
            for (int i = 0; i < 1 + lootingLevel; ++i) {
                willDropTrophy = willDropTrophy || chance >= deadEntity.m_9236_().f_46441_.m_188500_();
            }
        }
        if (!willDropTrophy) return;
        ItemStack trophy = TrophyBlock.createPlayerTrophy(killedPlayer);
        Block.m_49840_((Level)deadEntity.m_9236_(), (BlockPos)deadEntity.m_20183_(), (ItemStack)trophy);
    }

    private void onAdvancementEarned(AdvancementEvent.AdvancementEarnEvent event) {
        if (ModList.get().isLoaded("the_bumblezone")) {
            ItemStack trophy = null;
            if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("the_bumblezone", "the_bumblezone/the_queens_desire/journeys_end"))) {
                trophy = TrophyBlock.createTrophy("the_bumblezone:bee_queen", new CompoundTag(), "Queen Bee");
            } else if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("the_bumblezone", "the_bumblezone/beehemoth/queen_beehemoth"))) {
                trophy = TrophyBlock.createTrophy("the_bumblezone:beehemoth", new CompoundTag(), "Beehemoth");
            }
            if (trophy != null && event.getEntity().m_36356_(trophy)) {
                event.getEntity().m_36176_(trophy, false);
            }
        }
    }

    private static String idToName(String id) {
        int start = id.indexOf(":") + 1;
        return id.substring(start, start + 1).toUpperCase() + id.substring(start + 1).replace("_", " ");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="trophymanager")
    public static class EventHandler {
        @SubscribeEvent
        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey().equals((Object)CreativeModeTabs.f_256837_)) {
                String[] entities;
                for (String entityId : entities = new String[]{"allay", "axolotl", "bat", "bee", "blaze", "camel", "cat", "cave_spider", "chicken", "cow", "creeper", "dolphin", "donkey", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "fox", "frog", "ghast", "glow_squid", "goat", "guardian", "hoglin", "horse", "husk", "illusioner", "iron_golem", "llama", "magma_cube", "mule", "mooshroom", "ocelot", "panda", "parrot", "phantom", "pig", "piglin", "piglin_brute", "pillager", "polar_bear", "pufferfish", "rabbit", "ravager", "sheep", "shulker", "silverfish", "skeleton", "skeleton_horse", "slime", "snow_golem", "spider", "squid", "stray", "strider", "tadpole", "trader_llama", "tropical_fish", "turtle", "vex", "villager", "vindicator", "wandering_trader", "warden", "witch", "wither", "wither_skeleton", "wolf", "zoglin", "zombie", "zombie_horse", "zombie_villager", "zombified_piglin"}) {
                    event.m_246342_(TrophyBlock.createTrophy("minecraft:" + entityId, new CompoundTag(), TrophyManager.idToName("minecraft:" + entityId)));
                }
            }
        }
    }
}

