/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.gui;

import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.network.Networking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TrophyScreen
extends Screen {
    private static final int WIDTH = 150;
    private static final int HEIGHT = 150;
    private static final ResourceLocation GUI = new ResourceLocation("trophymanager", "textures/gui/trophy.png");
    private final TrophyBlockEntity trophy;

    protected TrophyScreen(BlockPos pos) {
        super((Component)Component.m_237115_((String)"gui.trophy.screen"));
        Level level = TrophyManager.proxy.getWorld();
        this.trophy = (TrophyBlockEntity)level.m_7702_(pos);
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 150) / 2;
        int relY = (this.f_96544_ - 150) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), button -> this.adjustScale(-1.0f)).m_252794_(relX + 10, relY + 10).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> this.adjustScale(1.0f)).m_252794_(relX + 120, relY + 10).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), button -> this.adjustOffsetY(-1.0)).m_252794_(relX + 10, relY + 35).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> this.adjustOffsetY(1.0)).m_252794_(relX + 120, relY + 35).m_253046_(20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> TrophyScreen.close()).m_252794_(relX + 10, relY + 60).m_253046_(65, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.ok"), button -> TrophyScreen.save(this)).m_252794_(relX + 76, relY + 60).m_253046_(65, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int relX = (this.f_96543_ - 150) / 2;
        int relY = (this.f_96544_ - 150) / 2;
        guiGraphics.m_280218_(GUI, relX, relY, 0, 0, 150, 150);
        guiGraphics.m_280137_(this.f_96547_, "" + this.trophy.scale, relX + 75, relY + 15, 0xA0A0A0);
        guiGraphics.m_280137_(this.f_96547_, "" + this.trophy.offsetY, relX + 75, relY + 40, 0xA0A0A0);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    private void adjustScale(float d) {
        if (Screen.m_96638_()) {
            d *= 10.0f;
        }
        this.trophy.scale = (float)Math.min((double)((float)Math.round(this.trophy.scale * 10.0f + d) / 10.0f), (Double)TrophyManagerConfig.GENERAL.maxSize.get());
    }

    private void adjustOffsetY(double d) {
        if (Screen.m_96638_()) {
            d *= 10.0;
        }
        this.trophy.offsetY = Math.min((double)Math.round(this.trophy.offsetY * 10.0 + d) / 10.0, (Double)TrophyManagerConfig.GENERAL.maxYOffset.get());
    }

    public static void open(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new TrophyScreen(pos));
    }

    public static void save(TrophyScreen screen) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("OffsetY", screen.trophy.offsetY);
        tag.m_128350_("Scale", screen.trophy.scale);
        Networking.sendToServer(new Networking.PacketUpdateTrophy(screen.trophy.m_58899_(), tag));
        TrophyScreen.close();
    }

    public static void close() {
        Minecraft.m_91087_().m_91152_(null);
    }
}

