/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.tileentity.TrophyBlockEntity;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private PlayerInfo playerInfo;
    PlayerModel<Player> playerModelRegular;
    PlayerModel<Player> playerModelSlim;

    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.playerModelRegular = new PlayerModel(context.m_173582_(ModelLayers.f_171162_), false);
        this.playerModelSlim = new PlayerModel(context.m_173582_(ModelLayers.f_171166_), true);
    }

    public void render(@Nonnull TrophyBlockEntity trophyTileEntity, float v, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (trophyTileEntity.trophyType != null) {
            Entity entity;
            if (trophyTileEntity.isOnHead) {
                poseStack.m_252880_(0.0f, 0.4f, 0.0f);
            }
            if (trophyTileEntity.trophyType.equals("item") && trophyTileEntity.item != null) {
                this.renderItem(trophyTileEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
            } else if (trophyTileEntity.trophyType.equals("entity") && (entity = trophyTileEntity.getCachedEntity()) != null) {
                this.renderEntity(trophyTileEntity, poseStack, buffer, combinedLightIn);
            }
        }
        this.renderBase(trophyTileEntity, poseStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderBase(TrophyBlockEntity trophyTileEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Block baseBlock;
        Block block = baseBlock = trophyTileEntity.isOnHead ? Blocks.f_50016_ : trophyTileEntity.getBaseBlock();
        if (baseBlock != null) {
            Minecraft.m_91087_().m_91289_().m_110912_(baseBlock.m_49966_(), poseStack, buffer, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderItem(TrophyBlockEntity trophyBlockEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        double tick = 0.0;
        if (((Boolean)TrophyManagerConfig.GENERAL.rotateItemTrophies.get()).booleanValue()) {
            tick = (double)System.currentTimeMillis() / 800.0;
        } else if (trophyBlockEntity.m_58904_() != null) {
            Direction facing = (Direction)trophyBlockEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (facing == Direction.NORTH) {
                tick = 6.0;
            } else if (facing == Direction.SOUTH) {
                tick = 0.0;
            } else if (facing == Direction.EAST) {
                tick = 3.0;
            } else if (facing == Direction.WEST) {
                tick = 9.0;
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, trophyBlockEntity.offsetY + 0.5 + Math.sin(tick / 25.0) / 15.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(tick * 30.0 % 360.0)));
        poseStack.m_85841_(trophyBlockEntity.scale, trophyBlockEntity.scale, trophyBlockEntity.scale);
        Minecraft.m_91087_().m_91291_().m_269128_(trophyBlockEntity.item, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, buffer, trophyBlockEntity.m_58904_(), 0);
        poseStack.m_85849_();
    }

    private void renderEntity(TrophyBlockEntity trophyTileEntity, PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn) {
        float angle = 0.0f;
        if (trophyTileEntity.m_58904_() != null) {
            Direction facing = (Direction)trophyTileEntity.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (facing == Direction.NORTH) {
                angle = 180.0f;
            } else if (facing == Direction.SOUTH) {
                angle = 0.0f;
            } else if (facing == Direction.EAST) {
                angle = 90.0f;
            } else if (facing == Direction.WEST) {
                angle = 270.0f;
            }
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, trophyTileEntity.offsetY, 0.5);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(trophyTileEntity.rotX));
        matrixStack.m_85841_(trophyTileEntity.scale, trophyTileEntity.scale, trophyTileEntity.scale);
        if (trophyTileEntity.entity.m_128461_("entityType").equals("minecraft:ender_dragon")) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        EntityRenderDispatcher entityRendererManager = Minecraft.m_91087_().m_91290_();
        entityRendererManager.m_114468_(false);
        Entity cachedEntity = trophyTileEntity.getCachedEntity();
        if (cachedEntity != null) {
            entityRendererManager.m_114384_(cachedEntity, 0.0, 0.0, 0.0, Minecraft.m_91087_().m_91296_(), 1.0f, matrixStack, buffer, combinedLightIn);
            TrophyBlockEntityRenderer.renderPassengers(cachedEntity, entityRendererManager, matrixStack, buffer, combinedLightIn);
        }
        matrixStack.m_85849_();
    }

    private static void renderPassengers(Entity entity, EntityRenderDispatcher entityRendererManager, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn) {
        if (entity.m_20160_()) {
            for (Entity rider : entity.m_20197_()) {
                entity.m_7332_(rider);
                entityRendererManager.m_114384_(rider, rider.m_20185_(), rider.m_20186_(), rider.m_20189_(), Minecraft.m_91087_().m_91296_(), 1.0f, matrixStack, buffer, combinedLightIn);
                TrophyBlockEntityRenderer.renderPassengers(rider, entityRendererManager, matrixStack, buffer, combinedLightIn);
            }
        }
    }

    private void renderPlayer(TrophyBlockEntity trophyTileEntity, PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
    }

    @Nullable
    protected PlayerInfo getPlayerInfo(UUID uuid) {
        if (this.playerInfo == null) {
            this.playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
        }
        return this.playerInfo;
    }

    public boolean isSkinLoaded(UUID uuid) {
        PlayerInfo playerinfo = this.getPlayerInfo(uuid);
        return playerinfo != null && playerinfo.m_105335_();
    }

    public ResourceLocation getSkinTextureLocation(UUID uuid) {
        PlayerInfo playerinfo = this.getPlayerInfo(uuid);
        return playerinfo == null ? DefaultPlayerSkin.m_118627_((UUID)uuid) : playerinfo.m_105337_();
    }
}

