/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core;

import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import com.teamabnormals.woodworks.core.data.client.WoodworksBlockStateProvider;
import com.teamabnormals.woodworks.core.data.client.WoodworksLanguageProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksLootTableProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksStructureRepaletterProvider;
import com.teamabnormals.woodworks.core.data.server.tags.WoodworksBlockTagsProvider;
import com.teamabnormals.woodworks.core.data.server.tags.WoodworksItemTagsProvider;
import com.teamabnormals.woodworks.core.other.WoodworksClientCompat;
import com.teamabnormals.woodworks.core.other.WoodworksCompat;
import com.teamabnormals.woodworks.core.registry.WoodworksMenuTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksRecipes;
import com.teamabnormals.woodworks.core.registry.helper.WoodworksBlockSubRegistryHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="woodworks")
public class Woodworks {
    public static final String MOD_ID = "woodworks";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"woodworks", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new WoodworksBlockSubRegistryHelper((RegistryHelper)helper)));

    public Woodworks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        WoodworksMenuTypes.MENU_TYPES.register(bus);
        WoodworksRecipes.WoodworksRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        WoodworksRecipes.WoodworksRecipeTypes.RECIPE_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        bus.addGenericListener(Block.class, this::registerConfigConditions);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WoodworksConfig.COMMON_SPEC);
    }

    private void registerConfigConditions(RegistryEvent.Register<Block> event) {
        DataUtil.registerConfigCondition((String)MOD_ID, (Object[])new Object[]{WoodworksConfig.COMMON});
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> WoodworksCompat.register());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            WoodworksClientCompat.register();
            WoodworksMenuTypes.registerScreens();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            WoodworksBlockTagsProvider blockTags = new WoodworksBlockTagsProvider(generator, fileHelper);
            generator.m_123914_((DataProvider)blockTags);
            generator.m_123914_((DataProvider)new WoodworksItemTagsProvider(generator, blockTags, fileHelper));
            generator.m_123914_((DataProvider)new WoodworksLootTableProvider(generator));
            generator.m_123914_((DataProvider)new WoodworksRecipeProvider(generator));
            generator.m_123914_((DataProvider)new WoodworksStructureRepaletterProvider(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new WoodworksBlockStateProvider(generator, fileHelper));
            generator.m_123914_((DataProvider)new WoodworksLanguageProvider(generator));
        }
    }
}

