/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterjungletemples.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterjungletemples.module.StructurePlacementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.exclusion.EnhancedExclusionZone;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class BetterJungleTemplePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<BetterJungleTemplePlacement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(placement -> placement.m_227072_()), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(placement -> placement.m_227073_()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(placement -> Float.valueOf(placement.m_227074_())), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(placement -> placement.m_227075_()), (App)StructurePlacement.ExclusionZone.f_227077_.optionalFieldOf("exclusion_zone").forGetter(placement -> placement.m_227076_()), (App)EnhancedExclusionZone.CODEC.optionalFieldOf("enhanced_exclusion_zone").forGetter(placement -> placement.enhancedExclusionZone), (App)ExtraCodecs.f_144628_.fieldOf("spacing").forGetter(placement -> placement.m_205003_()), (App)ExtraCodecs.f_144628_.fieldOf("separation").forGetter(placement -> placement.m_205004_()), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(placement -> placement.m_205005_())).apply((Applicative)builder, builder.stable(BetterJungleTemplePlacement::new))).flatXmap(BetterJungleTemplePlacement.verifySpacing(), DataResult::success).codec();
    private final Optional<EnhancedExclusionZone> enhancedExclusionZone;

    private static Function<BetterJungleTemplePlacement, DataResult<BetterJungleTemplePlacement>> verifySpacing() {
        return placement -> placement.m_205003_() <= placement.m_205004_() ? DataResult.error((String)"EnhancedRandomSpread's spacing has to be larger than separation") : DataResult.success((Object)placement);
    }

    public BetterJungleTemplePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, Float frequency, Integer salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Optional<EnhancedExclusionZone> enhancedExclusionZone, Integer spacing, Integer separation, RandomSpreadType randomSpreadType) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.enhancedExclusionZone = enhancedExclusionZone;
    }

    public StructurePlacementType<?> m_203443_() {
        return StructurePlacementTypeModule.BETTER_JUNGLE_TEMPLE_PLACEMENT;
    }

    protected boolean m_214090_(ChunkGenerator chunkGenerator, RandomState randomState, long seed, int chunkX, int chunkZ) {
        ChunkPos chunkPos = this.m_227008_(seed, chunkX, chunkZ);
        if (chunkPos.f_45578_ == chunkX && chunkPos.f_45579_ == chunkZ) {
            BlockPos structurePos = chunkPos.m_151394_(120);
            boolean isOceanOrRiverNear = chunkGenerator.m_62218_().m_213971_(structurePos.m_123341_(), structurePos.m_123342_(), structurePos.m_123343_(), 48, 2, biomeHolder -> biomeHolder.m_203656_(BiomeTags.f_207605_) || biomeHolder.m_203656_(BiomeTags.f_207603_), randomState.m_224582_().m_224542_(structurePos), true, randomState.m_224579_()) != null;
            return !isOceanOrRiverNear;
        }
        return false;
    }

    public boolean m_227054_(ChunkGenerator chunkGenerator, RandomState randomState, long seed, int x, int z) {
        if (!super.m_227054_(chunkGenerator, randomState, seed, x, z)) {
            return false;
        }
        return this.enhancedExclusionZone.isEmpty() || !this.enhancedExclusionZone.get().isPlacementForbidden(chunkGenerator, randomState, seed, x, z);
    }
}

