/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.init;

import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import com.yungnickyoung.minecraft.yungsextras.YungsExtras;
import com.yungnickyoung.minecraft.yungsextras.config.YEConfig;
import com.yungnickyoung.minecraft.yungsextras.world.WishingWellChances;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.loader.api.FabricLoader;

public class YEModConfig {
    public static void init() {
        YEModConfig.initCustomFiles();
        AutoConfig.register(YEConfig.class, Toml4jConfigSerializer::new);
        YungsExtras.CONFIG = (YEConfig)AutoConfig.getConfigHolder(YEConfig.class).getConfig();
    }

    private static void initCustomFiles() {
        YEModConfig.createDirectory();
        YEModConfig.createBaseReadMe();
        YEModConfig.createJsonReadMe();
        YEModConfig.loadJSON();
    }

    private static void loadJSON() {
        YEModConfig.loadWishingWellsJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FabricLoader.getInstance().getConfigDir().toString(), "YungsExtras");
        File customConfigDir = new File(parentDir, "fabric-1_18");
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                YungsExtras.LOGGER.info("Creating directory for additional YUNG's Extras configuration at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            YungsExtras.LOGGER.error("ERROR creating YUNG's Extras config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "YungsExtras", "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Extras.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run YUNG's Extras, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use YUNG's Extras for MC 1.16 on Forge, the 'forge-1_16' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.\n\nNOTE -- MOST OPTIONS CAN BE FOUND IN A CONFIG FILE OUTSIDE THIS FOLDER!\nFor example, on Forge 1.16 the file is 'YungsExtras-forge-1_16.toml'.";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                YungsExtras.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "YungsExtras", "fabric-1_18", "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#        wishing_wells.json          #\n######################################\n\nThis file contains a BlockSetSelector (see below) describing the probability of a given block being chosen.\nThese probabilities are used for Wishing Wells, which have \nloot deposits at the bottom of them.\n\n######################################\n#         BlockSetSelectors          #\n######################################\n\nDescribes a set of blockstates and the probability of each blockstate being chosen.\n - entries: An object where each entry's key is a blockstate, and each value is that blockstate's probability of being chosen.\n      The total sum of all probabilities SHOULD NOT exceed 1.0!\n - defaultBlock: The blockstate used for any leftover probability ranges.\n      For example, if the total sum of all the probabilities of the entries is 0.6, then\n      there is a 0.4 chance of the defaultBlock being selected.\n\nHere's an example block selector:\n\"entries\": {\n  \"minecraft:cobblestone\": 0.25,\n  \"minecraft:air\": 0.2,\n  \"minecraft:stone_bricks\": 0.1\n},\n\"defaultBlock\": \"minecraft:oak_planks\"\n\nFor each block, this selector has a 25% chance of returning cobblestone, 20% chance of choosing air,\n10% chance of choosing stone bricks, and a 100 - (25 + 20 + 10) = 45% chance of choosing oak planks (since it's the default block).\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                YungsExtras.LOGGER.error("Unable to create wishing wells README file!");
            }
        }
    }

    private static void loadWishingWellsJSON() {
        Path jsonPath = Paths.get(FabricLoader.getInstance().getConfigDir().toString(), "YungsExtras", "fabric-1_18", "wishing_wells.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)WishingWellChances.get());
            }
            catch (IOException e) {
                YungsExtras.LOGGER.error("Unable to create wishing_wells.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                YungsExtras.LOGGER.error("YUNG's Extras wishing_wells.json file not readable! Using default configuration...");
                return;
            }
            try {
                WishingWellChances.instance = (WishingWellChances)JSON.loadObjectFromJsonFile((Path)jsonPath, WishingWellChances.class);
            }
            catch (IOException e) {
                YungsExtras.LOGGER.error("Error loading YUNG's Extras wishing_wells.json file: {}", (Object)e.toString());
                YungsExtras.LOGGER.error("Using default configuration...");
            }
        }
    }
}

