/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.init;

import com.yungnickyoung.minecraft.yungsextras.YungsExtras;
import com.yungnickyoung.minecraft.yungsextras.init.YEModConfiguredFeatures;
import com.yungnickyoung.minecraft.yungsextras.util.NamedFeature;
import com.yungnickyoung.minecraft.yungsextras.world.config.StructurePathConfig;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.misc.ChillzoneDesertFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.misc.GiantDesertTorchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.misc.SmallRuinsDesertFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.obelisk.CreeperDesertObeliskFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.obelisk.DesertObeliskFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.obelisk.RareDesertObeliskFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.obelisk.RuinedDesertObeliskFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.dry.LargeDesertDryWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.dry.MedDesertDryWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.dry.SmallDesertDryWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.normal.LargeDesertWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.normal.MedDesertWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.normal.SmallDesertWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.wishing.LargeDesertWishingWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.wishing.MedDesertWishingWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well.wishing.SmallDesertWishingWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampArchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampChurchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampCubbyFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampDoubleArchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampOgreFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampPillarFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_6796;
import net.minecraft.class_6814;

public class YEModFeatures {
    public static final List<NamedFeature<?>> NAMED_FEATURES = new ArrayList();
    public static final NamedFeature<class_3111> WELL_SM = YEModFeatures.addFeature(SmallDesertWellFeature::new, "desert_well_sm");
    public static final NamedFeature<class_3111> WELL_MD = YEModFeatures.addFeature(MedDesertWellFeature::new, "desert_well_md");
    public static final NamedFeature<class_3111> WELL_LG = YEModFeatures.addFeature(LargeDesertWellFeature::new, "desert_well_lg");
    public static final NamedFeature<class_3111> DRY_WELL_SM = YEModFeatures.addFeature(SmallDesertDryWellFeature::new, "desert_dry_well_sm");
    public static final NamedFeature<class_3111> DRY_WELL_MD = YEModFeatures.addFeature(MedDesertDryWellFeature::new, "desert_dry_well_md");
    public static final NamedFeature<class_3111> DRY_WELL_LG = YEModFeatures.addFeature(LargeDesertDryWellFeature::new, "desert_dry_well_lg");
    public static final NamedFeature<class_3111> WISHING_WELL_SM = YEModFeatures.addFeature(SmallDesertWishingWellFeature::new, "desert_wishing_well_sm");
    public static final NamedFeature<class_3111> WISHING_WELL_MD = YEModFeatures.addFeature(MedDesertWishingWellFeature::new, "desert_wishing_well_md");
    public static final NamedFeature<class_3111> WISHING_WELL_LG = YEModFeatures.addFeature(LargeDesertWishingWellFeature::new, "desert_wishing_well_lg");
    public static final NamedFeature<class_3111> OBELISK = YEModFeatures.addFeature(DesertObeliskFeature::new, "desert_obelisk");
    public static final NamedFeature<class_3111> OBELISK_CREEPER = YEModFeatures.addFeature(CreeperDesertObeliskFeature::new, "desert_obelisk_creeper");
    public static final NamedFeature<class_3111> OBELISK_RUINED = YEModFeatures.addFeature(RuinedDesertObeliskFeature::new, "desert_obelisk_ruined");
    public static final NamedFeature<class_3111> OBELISK_RARE = YEModFeatures.addFeature(RareDesertObeliskFeature::new, "desert_obelisk_rare");
    public static final NamedFeature<class_3111> GIANT_TORCH = YEModFeatures.addFeature(GiantDesertTorchFeature::new, "desert_giant_torch");
    public static final NamedFeature<class_3111> DESERT_RUINS_0 = YEModFeatures.addFeature(SmallRuinsDesertFeature::new, "desert_ruins_0");
    public static final NamedFeature<class_3111> CHILLZONE = YEModFeatures.addFeature(ChillzoneDesertFeature::new, "desert_chillzone");
    public static final NamedFeature<StructurePathConfig> SWAMP_PILLAR = YEModFeatures.addFeature(SwampPillarFeature::new, "swamp_pillar");
    public static final NamedFeature<StructurePathConfig> SWAMP_OGRE = YEModFeatures.addFeature(SwampOgreFeature::new, "swamp_ogre");
    public static final NamedFeature<StructurePathConfig> SWAMP_CUBBY = YEModFeatures.addFeature(SwampCubbyFeature::new, "swamp_cubby");
    public static final NamedFeature<StructurePathConfig> SWAMP_ARCH = YEModFeatures.addFeature(SwampArchFeature::new, "swamp_arch");
    public static final NamedFeature<StructurePathConfig> SWAMP_DOUBLE_ARCH = YEModFeatures.addFeature(SwampDoubleArchFeature::new, "swamp_double_arch");
    public static final NamedFeature<StructurePathConfig> SWAMP_CHURCH = YEModFeatures.addFeature(SwampChurchFeature::new, "swamp_church");

    private static <FC extends class_3037> NamedFeature<FC> addFeature(Supplier<class_3031<FC>> featureSupplier, String name) {
        class_3031<FC> feature = featureSupplier.get();
        NamedFeature<FC> namedFeature = new NamedFeature<FC>(name, feature);
        NAMED_FEATURES.add(namedFeature);
        return namedFeature;
    }

    public static void init() {
        YEModFeatures.registerFeatures();
        YEModConfiguredFeatures.registerConfiguredFeatures();
        YEModConfiguredFeatures.registerPlacedFeatures();
        YEModFeatures.addFeaturesToBiomes();
    }

    private static void registerFeatures() {
        NAMED_FEATURES.forEach(namedFeature -> {
            class_3031 feature = namedFeature.feature();
            String name = namedFeature.name();
            class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)new class_2960("yungsextras", name), feature);
        });
    }

    private static void addFeaturesToBiomes() {
        BiomeModifications.create((class_2960)new class_2960("yungsextras", "vanilla_desert_well_removal")).add(ModificationPhase.REMOVALS, biomeSelectionContext -> biomeSelectionContext.hasBuiltInPlacedFeature(class_6814.field_36014), modificationContext -> modificationContext.getGenerationSettings().removeBuiltInFeature(class_6814.field_36014));
        BiomeModifications.create((class_2960)new class_2960("yungsextras", "desert_decorations_addition")).add(ModificationPhase.ADDITIONS, context -> YEModFeatures.selectBiomes(context, class_1959.class_1961.field_9368), context -> YEModFeatures.modifyBiomes(context, class_1959.class_1961.field_9368));
        BiomeModifications.create((class_2960)new class_2960("yungsextras", "swamp_structures_addition")).add(ModificationPhase.ADDITIONS, context -> YEModFeatures.selectBiomes(context, class_1959.class_1961.field_9364), context -> YEModFeatures.modifyBiomes(context, class_1959.class_1961.field_9364));
    }

    private static boolean selectBiomes(BiomeSelectionContext context, class_1959.class_1961 biomeCategory) {
        String biomeName = context.getBiomeKey().method_29177().toString();
        if (YungsExtras.blacklistedBiomes.contains(biomeName)) {
            return false;
        }
        return context.getBiome().method_8688() == biomeCategory || YungsExtras.additionalWhitelistedBiomes.contains(biomeName);
    }

    private static void modifyBiomes(BiomeModificationContext context, class_1959.class_1961 biomeCategory) {
        YEModConfiguredFeatures.NAMED_PLACED_FEATURES_BY_BIOME.get(biomeCategory).forEach(namedPlacedFeature -> {
            class_6796 placedFeature = namedPlacedFeature.placedFeature();
            context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13173, placedFeature);
        });
    }
}

