/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.yungnickyoung.minecraft.yungsapi.YungsApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockSetSelector {
    private Map<BlockState, Float> entries = new HashMap<BlockState, Float>();
    private BlockState defaultBlockState = Blocks.f_50016_.m_49966_();

    public BlockSetSelector(BlockState defaultBlockState) {
        this.defaultBlockState = defaultBlockState;
    }

    public BlockSetSelector() {
    }

    public static BlockSetSelector from(BlockState ... blockStates) {
        BlockSetSelector selector = new BlockSetSelector();
        float chance = 1.0f / (float)blockStates.length;
        for (BlockState state : blockStates) {
            selector.addBlock(state, chance);
        }
        return selector;
    }

    public BlockSetSelector addBlock(BlockState blockState, float chance) {
        if (this.entries.containsKey(blockState)) {
            YungsApi.LOGGER.warn("WARNING: duplicate block {} added to BlockSelector!", (Object)blockState.toString());
            return this;
        }
        float currTotal = this.entries.values().stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApi.LOGGER.warn("WARNING: block {} added to BlockSelector exceeds max probabiltiy of 1!", (Object)blockState.toString());
            return this;
        }
        this.entries.put(blockState, Float.valueOf(chance));
        return this;
    }

    public BlockState get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Map.Entry<BlockState, Float> entry : this.entries.entrySet()) {
            float chance = entry.getValue().floatValue();
            if (currBottom <= target && target < currBottom + chance) {
                return entry.getKey();
            }
            currBottom += chance;
        }
        return this.defaultBlockState;
    }

    public void setDefaultBlockState(BlockState blockState) {
        this.defaultBlockState = blockState;
    }

    public Map<BlockState, Float> getEntries() {
        return this.entries;
    }

    public BlockState getDefaultBlockState() {
        return this.defaultBlockState;
    }
}

