/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.yungnickyoung.minecraft.yungsapi.YungsApi;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ItemSetSelector {
    private Map<Item, Float> entries = new HashMap<Item, Float>();
    private Item defaultItem = Items.f_41852_;

    public ItemSetSelector(Item defaultItem) {
        this.defaultItem = defaultItem;
    }

    public ItemSetSelector() {
    }

    public static ItemSetSelector from(Item ... items) {
        ItemSetSelector selector = new ItemSetSelector();
        float chance = 1.0f / (float)items.length;
        for (Item item : items) {
            selector.addItem(item, chance);
        }
        return selector;
    }

    public ItemSetSelector addItem(Item item, float chance) {
        if (this.entries.containsKey(item)) {
            YungsApi.LOGGER.warn("WARNING: duplicate item {} added to ItemSetSelector!", (Object)item.toString());
            return this;
        }
        float currTotal = this.entries.values().stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApi.LOGGER.warn("WARNING: item {} added to ItemSetSelector exceeds max probabiltiy of 1!", (Object)item.toString());
            return this;
        }
        this.entries.put(item, Float.valueOf(chance));
        return this;
    }

    public Item get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Map.Entry<Item, Float> entry : this.entries.entrySet()) {
            float chance = entry.getValue().floatValue();
            if (currBottom <= target && target < currBottom + chance) {
                return entry.getKey();
            }
            currBottom += chance;
        }
        return this.defaultItem;
    }

    public void setDefaultItem(Item item) {
        this.defaultItem = item;
    }

    public Map<Item, Float> getEntries() {
        return this.entries;
    }

    public Item getDefaultItem() {
        return this.defaultItem;
    }
}

