/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungsextras.YungsExtras;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class AbstractTemplateFeature<C extends FeatureConfiguration>
extends Feature<C> {
    public AbstractTemplateFeature(Codec<C> codec) {
        super(codec);
    }

    protected StructureTemplate createTemplate(ResourceLocation templateName, WorldGenLevel level, Random rand, BlockPos centerPos) {
        Optional templateOptional = level.m_6018_().m_8875_().m_163774_(templateName);
        if (templateOptional.isEmpty()) {
            YungsExtras.LOGGER.warn("Failed to create invalid feature {}", (Object)templateName);
            return null;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.m_142082_(-template.m_163801_().m_123341_() / 2, 0, -template.m_163801_().m_123343_() / 2);
        StructurePlaceSettings placement = new StructurePlaceSettings();
        template.m_74536_((ServerLevelAccessor)level, cornerPos, centerPos, placement, rand, 2);
        this.processTemplate(template, level, rand, cornerPos, centerPos, placement);
        return template;
    }

    protected void processTemplate(StructureTemplate template, WorldGenLevel world, Random rand, BlockPos cornerPos, BlockPos centerPosm, StructurePlaceSettings placementSettings) {
    }
}

