/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.desert.well;

import com.yungnickyoung.minecraft.yungsextras.world.WishingWellChances;
import com.yungnickyoung.minecraft.yungsextras.world.feature.AbstractTemplateFeature;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
public abstract class AbstractDesertWellFeature
extends AbstractTemplateFeature<NoneFeatureConfiguration> {
    private static final String path = "desert/wells/";
    private final int radius;
    protected ResourceLocation name;

    public AbstractDesertWellFeature(String name, int size) {
        super(NoneFeatureConfiguration.f_67815_);
        this.name = new ResourceLocation("yungsextras", path + name);
        this.radius = size;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos pos = context.m_159777_();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (level.m_46859_((BlockPos)mutable) && mutable.m_123342_() > 7) {
            mutable.m_122173_(Direction.DOWN);
        }
        BlockPos surfacePos = mutable.m_7949_();
        Block block = level.m_8055_(surfacePos).m_60734_();
        if (!BlockTags.f_13029_.m_8110_((Object)block)) {
            return false;
        }
        for (int i = 1; i <= 7; ++i) {
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.NORTH, this.radius).m_122175_(Direction.EAST, this.radius);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.EAST, this.radius).m_122175_(Direction.SOUTH, this.radius);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.SOUTH, this.radius).m_122175_(Direction.WEST, this.radius);
            if (level.m_46859_((BlockPos)mutable)) {
                return false;
            }
            mutable.m_122190_((Vec3i)surfacePos).m_122175_(Direction.DOWN, i).m_122175_(Direction.WEST, this.radius).m_122175_(Direction.NORTH, this.radius);
            if (!level.m_46859_((BlockPos)mutable)) continue;
            return false;
        }
        StructureTemplate template = this.createTemplate(this.name, level, rand, surfacePos.m_5484_(Direction.DOWN, 6));
        return template != null;
    }

    @Override
    protected void processTemplate(StructureTemplate template, WorldGenLevel world, Random rand, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50204_)) {
            BlockState blockState = WishingWellChances.get().getRandomLootBlock(rand);
            world.m_7731_(blockInfo.f_74675_, blockState, 2);
        }
    }
}

